/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class StringUtils {
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    private static final String NL = System.getProperty("line.separator");
    private static final String INDENT = " ";

    public static String concatenate(String text1, String text2, String delimiter) {
        StringBuffer buf = new StringBuffer();
        if (text1 != null && text1.length() > 0) {
            buf.append(text1);
        }
        if (text2 != null && text2.length() > 0) {
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            buf.append(text2);
        }
        return buf.toString();
    }

    public static String collectionToDelimitedString(Collection coll, String delim) {
        if (coll == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(it.next());
            ++i;
        }
        return sb.toString();
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public static boolean isCapitalized(String string) {
        if (string != null && string.length() > 0) {
            return !Character.isUpperCase(string.charAt(0));
        }
        return false;
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static boolean isAlphaNumeric(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return false;
        }
        int i = 0;
        while (i < strLen) {
            char c = str.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        String[] tokens = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)str);
        int i = 0;
        while (i < tokens.length) {
            set.add(tokens[i]);
            ++i;
        }
        return set;
    }

    public static String prettyPrintJson(String json) {
        if (json == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        char[] chars = json.toCharArray();
        int indent = 0;
        long quoteCount = 0L;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\"') {
                b.append(c);
                ++quoteCount;
            } else if (c == '{' || c == '[') {
                b.append(c).append(NL);
                StringUtils.indent(b, ++indent);
            } else if (c == '}' || c == ']') {
                b.append(NL);
                StringUtils.indent(b, --indent);
                b.append(c);
            } else if (c == ',' && quoteCount % 2L == 0L) {
                b.append(c).append(NL);
                StringUtils.indent(b, indent);
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    private static void indent(StringBuilder b, int level) {
        int i = 0;
        while (i < level) {
            b.append(INDENT);
            ++i;
        }
    }

    public static boolean hasText(String name) {
        return name != null && !"".equals(name.trim());
    }
}

