/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.springframework.ide.eclipse.core.java.ProjectClassLoaderCache;

public class FilteringURLClassLoader
extends URLClassLoader {
    private static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(new ArrayList());

    public FilteringURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL findResource(String resourceName) {
        if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
            return null;
        }
        return super.findResource(resourceName);
    }

    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
            return EMPTY_ENUMERATION;
        }
        return super.findResources(resourceName);
    }

    @Override
    public URL getResource(String name) {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return EMPTY_ENUMERATION;
        }
        return super.getResources(name);
    }
}

