/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.AjdtUtils;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;

public final class Introspector {
    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static boolean doesExtend(IType type, String className) {
        if (System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true")) {
            return SpringCore.getTypeHierarchyEngine().doesExtend(type, className);
        }
        return Introspector.hasSuperType(type, className, false);
    }

    public static boolean doesImplement(IType type, String interfaceName) {
        if (System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true")) {
            return SpringCore.getTypeHierarchyEngine().doesImplement(type, interfaceName);
        }
        return Introspector.hasSuperType(type, interfaceName, true);
    }

    public static Set<IMethod> findAllConstructors(IType type) throws JavaModelException {
        HashMap<String, IMethod> allConstructors = new HashMap<String, IMethod>();
        while (type != null) {
            IMethod[] iMethodArray = Introspector.getMethods(type);
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!allConstructors.containsKey(key) && method.isConstructor()) {
                    allConstructors.put(key, method);
                }
                ++n2;
            }
            type = Introspector.getSuperType(type);
        }
        return new HashSet<IMethod>(allConstructors.values());
    }

    public static Set<IMethod> findAllMethods(IType type, IMethodFilter filter) {
        return Introspector.findAllMethods(type, "", filter);
    }

    public static Set<IMethod> findAllMethods(IType type, String prefix, IMethodFilter filter) {
        LinkedHashSet<IMethod> methods = new LinkedHashSet<IMethod>();
        try {
            if (type != null && type.isInterface()) {
                HashSet<IType> types = new HashSet<IType>();
                types.add(type);
                IMethod[] iMethodArray = Introspector.getMethods(type);
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (!method.isConstructor() && filter.matches(method, prefix)) {
                        methods.add(method);
                    }
                    ++n2;
                }
                for (IType interfaceType : Introspector.getAllImplementedInterfaces(type)) {
                    methods.addAll(Introspector.findAllMethods(interfaceType, prefix, filter));
                }
            }
            while (type != null) {
                IMethod[] iMethodArray = Introspector.getMethods(type);
                int n = iMethodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IMethod method = iMethodArray[n3];
                    if (!method.isConstructor() && filter.matches(method, prefix)) {
                        methods.add(method);
                    }
                    ++n3;
                }
                type = Introspector.getSuperType(type);
            }
        }
        catch (JavaModelException javaModelException) {}
        return methods;
    }

    public static Set<IAnnotation> getAllAnnotations(IType type) throws JavaModelException {
        LinkedHashSet<IAnnotation> annotations = new LinkedHashSet<IAnnotation>();
        while (type != null && !type.isInterface()) {
            annotations.addAll(Arrays.asList(type.getAnnotations()));
            type = Introspector.getSuperType(type);
        }
        return annotations;
    }

    public static Set<IMethod> findAllMethods(IType type, String methodPrefix, int argCount, Public publics, Static statics) throws JavaModelException {
        return Introspector.findAllMethods(type, methodPrefix, argCount, publics, statics, false);
    }

    public static Set<IMethod> findAllMethods(IType type, String methodPrefix, int argCount, Public publics, Static statics, boolean ignoreCase) throws JavaModelException {
        HashMap<String, IMethod> allMethods = new HashMap<String, IMethod>();
        while (type != null) {
            IMethod[] iMethodArray = Introspector.getMethods(type);
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                Introspector.checkMethod(type, methodPrefix, argCount, publics, statics, ignoreCase, allMethods, method);
                ++n2;
            }
            type = Introspector.getSuperType(type);
        }
        return new HashSet<IMethod>(allMethods.values());
    }

    private static void checkMethod(IType type, String methodPrefix, int argCount, Public publics, Static statics, boolean ignoreCase, Map<String, IMethod> allMethods, IMethod method) throws JavaModelException {
        int flags = method.getFlags();
        String key = String.valueOf(method.getElementName()) + method.getSignature();
        if (!allMethods.containsKey(key) && !method.isConstructor() && (publics == Public.DONT_CARE || publics == Public.YES && (Flags.isPublic((int)flags) || Flags.isInterface((int)type.getFlags())) || publics == Public.NO && !Flags.isPublic((int)flags) && !Flags.isInterface((int)type.getFlags())) && (statics == Static.DONT_CARE || statics == Static.YES && Flags.isStatic((int)flags) || statics == Static.NO && !Flags.isStatic((int)flags)) && (argCount == -1 || method.getNumberOfParameters() == argCount) && Introspector.checkMethodNamePrefix(method, type, methodPrefix, ignoreCase)) {
            allMethods.put(key, method);
        }
    }

    private static boolean checkMethodNamePrefix(IMethod method, IType type, String methodPrefix, boolean ignoreCase) {
        String methodName = JdtUtils.getMethodName(method);
        return !ignoreCase && methodName.startsWith(methodPrefix) || ignoreCase && methodName.toLowerCase().startsWith(methodPrefix.toLowerCase());
    }

    private static boolean checkMethodName(IMethod method, IType type, String methodName, boolean ignoreCase) {
        String realMethodName = JdtUtils.getMethodName(method);
        return !ignoreCase && realMethodName.equals(methodName) || ignoreCase && realMethodName.toLowerCase().startsWith(methodName.toLowerCase());
    }

    public static Set<IMethod> findAllNoParameterMethods(IType type, String prefix) throws JavaModelException {
        if (prefix == null) {
            prefix = "";
        }
        return Introspector.findAllMethods(type, prefix, 0, Public.DONT_CARE, Static.DONT_CARE);
    }

    public static Set<IMethod> findAllWritableProperties(IType type) throws JavaModelException {
        return Introspector.findAllMethods(type, "set", 1, Public.YES, Static.NO);
    }

    public static IMethod findMethod(IType type, String methodName, int argCount, Public publics, Static statics) throws JavaModelException {
        return Introspector.findMethod(type, methodName, argCount, publics, statics, null);
    }

    public static IMethod findMethod(IType type, String methodName, int argCount, Public publics, Static statics, TypeHierarchyEngine typeHierarchyEngine) throws JavaModelException {
        IType itrType = type;
        while (itrType != null) {
            IMethod method = Introspector.findMethodOnType(itrType, methodName, argCount, publics, statics);
            if (method != null) {
                return method;
            }
            itrType = Introspector.getSuperType(itrType, typeHierarchyEngine);
        }
        for (IType interfaceType : Introspector.getAllImplementedInterfaces(type, typeHierarchyEngine)) {
            IMethod method = Introspector.findMethod(interfaceType, methodName, argCount, publics, statics);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static IMethod findMethodOnType(IType type, String methodName, int argCount, Public publics, Static statics) throws JavaModelException {
        IMethod[] iMethodArray = Introspector.getMethods(type);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            int flags = method.getFlags();
            if ((publics == Public.DONT_CARE || publics == Public.YES && (Flags.isPublic((int)flags) || Flags.isInterface((int)type.getFlags())) || publics == Public.NO && !Flags.isPublic((int)flags) && !Flags.isInterface((int)type.getFlags())) && (statics == Static.DONT_CARE || statics == Static.YES && Flags.isStatic((int)flags) || statics == Static.NO && !Flags.isStatic((int)flags)) && (argCount == -1 || method.getNumberOfParameters() == argCount) && Introspector.checkMethodName(method, type, methodName, false)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static Set<IMethod> findReadableProperties(IType type, String methodPrefix) throws JavaModelException {
        String base = Introspector.capitalize(methodPrefix);
        return Introspector.findAllMethods(type, "get" + base, 0, Public.YES, Static.NO);
    }

    public static Set<IMethod> findReadableProperties(IType type, String methodPrefix, boolean ignoreCase) throws JavaModelException {
        String base = Introspector.capitalize(methodPrefix);
        return Introspector.findAllMethods(type, "get" + base, 0, Public.YES, Static.NO, ignoreCase);
    }

    public static Set<IMethod> findWritableProperties(IType type, String methodPrefix) throws JavaModelException {
        String base = Introspector.capitalize(methodPrefix);
        return Introspector.findAllMethods(type, "set" + base, 1, Public.YES, Static.NO);
    }

    public static Set<IMethod> findWritableProperties(IType type, String methodPrefix, boolean ignoreCase) throws JavaModelException {
        String base = Introspector.capitalize(methodPrefix);
        return Introspector.findAllMethods(type, "set" + base, 1, Public.YES, Static.NO, ignoreCase);
    }

    public static Set<IType> getAllImplementedInterfaces(IType type) {
        return Introspector.getAllImplementedInterfaces(type, null);
    }

    public static Set<IType> getAllImplementedInterfaces(IType type, TypeHierarchyEngine typeHierarchyEngine) {
        HashSet<IType> allInterfaces = new HashSet<IType>();
        try {
            while (type != null) {
                String[] interfaces = type.getSuperInterfaceTypeSignatures();
                if (interfaces != null) {
                    String[] stringArray = interfaces;
                    int n = interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String iface = stringArray[n2];
                        String fqin = JdtUtils.resolveClassNameBySignature(iface, type);
                        IType interfaceType = type.getJavaProject().findType(fqin);
                        if (interfaceType != null) {
                            allInterfaces.add(interfaceType);
                        }
                        ++n2;
                    }
                }
                type = Introspector.getSuperType(type, typeHierarchyEngine);
            }
        }
        catch (JavaModelException javaModelException) {}
        return allInterfaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean implementsInterface(IType type, String className) {
        try {
            while (true) {
                if (type == null) {
                    return false;
                }
                String[] interfaces = type.getSuperInterfaceTypeSignatures();
                if (interfaces != null) {
                    String[] stringArray = interfaces;
                    int n = interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String iface = stringArray[n2];
                        String fqin = JdtUtils.resolveClassNameBySignature(iface, type);
                        IType interfaceType = type.getJavaProject().findType(fqin);
                        if (interfaceType != null && interfaceType.getFullyQualifiedName().equals(className)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                type = Introspector.getSuperType(type);
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static Set<IMethod> getAllMethods(IType type) throws JavaModelException {
        return Introspector.getAllMethods(type, true);
    }

    public static Set<IMethod> getAllMethods(IType type, boolean includeHierarchy) throws JavaModelException {
        HashMap<String, IMethod> allMethods = new HashMap<String, IMethod>();
        while (type != null) {
            IMethod[] iMethodArray = Introspector.getMethods(type);
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String key = String.valueOf(method.getElementName()) + method.getSignature();
                if (!allMethods.containsKey(key) && !method.isConstructor()) {
                    allMethods.put(key, method);
                }
                ++n2;
            }
            if (!includeHierarchy) break;
            type = Introspector.getSuperType(type);
        }
        return new HashSet<IMethod>(allMethods.values());
    }

    public static Set<IMethod> getAllConstructors(IType type) throws JavaModelException {
        HashMap<String, IMethod> allMethods = new HashMap<String, IMethod>();
        IMethod[] iMethodArray = Introspector.getMethods(type);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String key = String.valueOf(method.getElementName()) + method.getSignature();
            if (!allMethods.containsKey(key) && method.isConstructor()) {
                allMethods.put(key, method);
            }
            ++n2;
        }
        return new HashSet<IMethod>(allMethods.values());
    }

    public static Set<IField> getAllFields(IType type) throws JavaModelException {
        return Introspector.getAllFields(type, true);
    }

    public static Set<IField> getAllFields(IType type, boolean includeHierarchy) throws JavaModelException {
        HashMap<String, IField> allFields = new HashMap<String, IField>();
        while (type != null) {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String key = field.getHandleIdentifier();
                if (!allFields.containsKey(key)) {
                    allFields.put(key, field);
                }
                ++n2;
            }
            if (!includeHierarchy) break;
            type = Introspector.getSuperType(type);
        }
        return new HashSet<IField>(allFields.values());
    }

    public static IMethod getReadableProperty(IType type, String propertyName) throws JavaModelException {
        String base = Introspector.capitalize(propertyName);
        return Introspector.findMethod(type, "get" + base, 0, Public.YES, Static.NO);
    }

    public static IType getSuperType(IType type) throws JavaModelException {
        TypeHierarchyEngine typeHierarchyEngine = System.getProperty("org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine", "true").equals("true") ? SpringCore.getTypeHierarchyEngine() : null;
        return Introspector.getSuperType(type, typeHierarchyEngine);
    }

    public static IType getSuperType(IType type, TypeHierarchyEngine typeHierarchyEngine) throws JavaModelException {
        if (type == null) {
            return null;
        }
        String name = type.getSuperclassName();
        if (name == null && !type.getFullyQualifiedName().equals(Object.class.getName())) {
            name = Object.class.getName();
        }
        if (name != null) {
            if (type.isBinary()) {
                return type.getJavaProject().findType(name);
            }
            if (typeHierarchyEngine != null) {
                String supertype = typeHierarchyEngine.getSupertype(type);
                if (supertype != null) {
                    return type.getJavaProject().findType(supertype);
                }
            } else {
                String resolvedName = JdtUtils.resolveClassName(name, type);
                if (resolvedName != null) {
                    return type.getJavaProject().findType(resolvedName);
                }
            }
        }
        return null;
    }

    public static IMethod getWritableProperty(IType type, String propertyName) throws JavaModelException {
        return Introspector.getWritableProperty(type, propertyName, null);
    }

    public static IMethod getWritableProperty(IType type, String propertyName, TypeHierarchyEngine typeHierarchyEngine) throws JavaModelException {
        String base = Introspector.capitalize(propertyName);
        return Introspector.findMethod(type, "set" + base, 1, Public.YES, Static.NO, typeHierarchyEngine);
    }

    public static Set<IMethod> getConstructors(IType type, int argCount, boolean isNonPublicAllowed) throws JavaModelException {
        IMethod[] methods = Introspector.getMethods(type);
        LinkedHashSet<IMethod> ctors = new LinkedHashSet<IMethod>();
        if (argCount > 0) {
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor() && method.getNumberOfParameters() == argCount && (isNonPublicAllowed || Flags.isPublic((int)method.getFlags()))) {
                    ctors.add(method);
                }
                ++n2;
            }
        }
        return ctors;
    }

    public static boolean hasConstructor(IType type, int argCount, boolean isNonPublicAllowed) throws JavaModelException {
        int n;
        IMethod[] methods = Introspector.getMethods(type);
        if (argCount == 0) {
            boolean hasExplicitConstructor = false;
            IMethod[] iMethodArray = methods;
            int n2 = methods.length;
            n = 0;
            while (n < n2) {
                IMethod method = iMethodArray[n];
                if (method.isConstructor()) {
                    hasExplicitConstructor = true;
                }
                ++n;
            }
            if (!hasExplicitConstructor) {
                return true;
            }
        }
        IMethod[] iMethodArray = methods;
        n = methods.length;
        int n3 = 0;
        while (n3 < n) {
            IMethod method = iMethodArray[n3];
            if (method.isConstructor() && method.getNumberOfParameters() == argCount && (isNonPublicAllowed || Flags.isPublic((int)method.getFlags()))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSuperType(IType type, String className, boolean isInterface) {
        if (type == null) return false;
        if (!type.exists()) return false;
        if (className == null) return false;
        if (className.length() <= 0) return false;
        try {
            if (isInterface) {
                if (!Introspector.implementsInterface(type, className)) return false;
                return true;
            }
            while (true) {
                if (type == null) {
                    return false;
                }
                if (className.equals(type.getFullyQualifiedName())) {
                    return true;
                }
                type = Introspector.getSuperType(type);
            }
        }
        catch (JavaModelException e) {
            SpringCore.log(e);
        }
        return false;
    }

    public static boolean hasSuperType(IType type, String className) {
        return Introspector.hasSuperType(type, className, false);
    }

    public static boolean hasWritableProperty(IType type, String propertyName) throws JavaModelException {
        return Introspector.hasWritableProperty(type, propertyName, null);
    }

    public static boolean hasWritableProperty(IType type, String propertyName, TypeHierarchyEngine typeHierarchyEngine) throws JavaModelException {
        String base = Introspector.capitalize(propertyName);
        return Introspector.findMethod(type, "set" + base, 1, Public.YES, Static.NO, typeHierarchyEngine) != null;
    }

    public static boolean isValidPropertyName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.length() == 1 && Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        return name.length() <= 1 || !Character.isUpperCase(name.charAt(0)) || !Character.isLowerCase(name.charAt(1));
    }

    public static IMethod[] getMethods(IType type) throws JavaModelException {
        if (type == null) {
            return new IMethod[0];
        }
        if (type.isStructureKnown()) {
            Set<IMethod> itdMethods;
            IMethod[] methods = type.getMethods();
            if (JdtUtils.isAjdtProject(type.getResource()) && (itdMethods = AjdtUtils.getDeclaredMethods(type)).size() > 0) {
                int i = methods.length;
                IMethod[] allMethods = new IMethod[methods.length + itdMethods.size()];
                System.arraycopy(methods, 0, allMethods, 0, methods.length);
                for (IMethod method : itdMethods) {
                    allMethods[i++] = method;
                }
                methods = allMethods;
            }
            return methods;
        }
        return new IMethod[0];
    }

    public static enum Public {
        YES,
        NO,
        DONT_CARE;

    }

    public static enum Static {
        YES,
        NO,
        DONT_CARE;

    }
}

