/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.model.validation.ValidationProgressState;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorStateAware;

public abstract class AbstractValidationContext
implements IValidationContext,
IProjectContributorStateAware,
IProjectContributorState {
    private IResourceModelElement contextElement;
    private IProjectContributorState contributorState;
    private ValidationRuleDefinition currentRuleDefinition;
    private Set<ValidationProblem> problems;
    private IResourceModelElement rootElement;

    public AbstractValidationContext(IResourceModelElement rootElement, IResourceModelElement contextElement) {
        this.rootElement = rootElement;
        this.contextElement = contextElement;
        this.problems = new LinkedHashSet<ValidationProblem>();
    }

    @Override
    public void addProblems(ValidationProblem ... problems) {
        if (problems != null) {
            this.addProblems(Arrays.asList(problems));
        }
    }

    @Override
    public void error(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        this.addProblems(this.createProblems(element, problemId, 2, message, attributes));
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return this.contributorState.get(clazz);
    }

    @Override
    public <T> T get(Class<T> clazz, String filterText) {
        return this.contributorState.get(clazz, filterText);
    }

    @Override
    public IResourceModelElement getContextElement() {
        return this.contextElement;
    }

    @Override
    public Set<ValidationProblem> getProblems() {
        return this.problems;
    }

    @Override
    public IResourceModelElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public boolean hold(Object obj) {
        return this.contributorState.hold(obj);
    }

    @Override
    public boolean hold(Object obj, Dictionary<String, String> attributes) {
        return this.contributorState.hold(obj, attributes);
    }

    @Override
    public void info(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        this.addProblems(this.createProblems(element, problemId, 0, message, attributes));
    }

    @Override
    public void setCurrentRuleDefinition(ValidationRuleDefinition ruleDefinition) {
        this.currentRuleDefinition = ruleDefinition;
    }

    @Override
    public void setProjectContributorState(IProjectContributorState contributorState) {
        this.contributorState = contributorState;
    }

    @Override
    public void warning(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        this.addProblems(this.createProblems(element, problemId, 1, message, attributes));
    }

    public TypeHierarchyEngine getTypeHierarchyEngine() {
        if (this.contributorState != null && this.contributorState.get(TypeHierarchyEngine.class) != null) {
            return this.contributorState.get(TypeHierarchyEngine.class);
        }
        return SpringCore.getTypeHierarchyEngine();
    }

    private void addProblems(Collection<ValidationProblem> problems) {
        if (problems != null) {
            for (ValidationProblem problem : problems) {
                if (problem.getSeverity() == 2) {
                    this.problems.add(problem);
                    this.getProgressReportingState().incrementErrorCount();
                    continue;
                }
                if (problem.getSeverity() == 1) {
                    this.problems.add(problem);
                    this.getProgressReportingState().incrementWarningCount();
                    continue;
                }
                if (problem.getSeverity() != 0) continue;
                this.problems.add(problem);
                this.getProgressReportingState().incrementInfoCount();
            }
        }
    }

    private ValidationProgressState getProgressReportingState() {
        if (this.contributorState != null && this.contributorState.get(ValidationProgressState.class) != null) {
            return this.contributorState.get(ValidationProgressState.class);
        }
        return new ValidationProgressState();
    }

    protected final ValidationProblem createProblem(IResourceModelElement element, String problemId, int severity, String message, ValidationProblemAttribute ... attributes) {
        int line = this.getLineNumber(element);
        message = this.decorateErrorMessage(new StringBuilder(message)).toString();
        String elementId = element.getElementID();
        ArrayList<ValidationProblemAttribute> attributeList = new ArrayList<ValidationProblemAttribute>(Arrays.asList(attributes));
        attributeList.add(new ValidationProblemAttribute("elementId", elementId));
        return new ValidationProblem(this.currentRuleDefinition != null ? this.currentRuleDefinition.getId() : "UNKOWN", problemId, this.getSeverity(problemId, severity), message, element.getElementResource(), line, attributeList.toArray(new ValidationProblemAttribute[attributeList.size()]));
    }

    protected Set<ValidationProblem> createProblems(IResourceModelElement element, String problemId, int severity, String message, ValidationProblemAttribute ... attributes) {
        LinkedHashSet<ValidationProblem> problems = new LinkedHashSet<ValidationProblem>(2);
        problems.add(this.createProblem(element, problemId, severity, message, attributes));
        return problems;
    }

    protected StringBuilder decorateErrorMessage(StringBuilder builder) {
        return builder;
    }

    protected int getLineNumber(IResourceModelElement element) {
        int line;
        int n = line = element instanceof ISourceModelElement ? ((ISourceModelElement)element).getElementStartLine() : -1;
        if (line == -1 && element.getElementParent() != null && element.getElementParent() instanceof IResourceModelElement) {
            return this.getLineNumber((IResourceModelElement)element.getElementParent());
        }
        return line;
    }

    protected IProjectContributorState getProjectContributorState() {
        return this.contributorState;
    }

    protected int getSeverity(String messageId, int defaultSeverity) {
        Integer severity;
        if (this.currentRuleDefinition != null && this.currentRuleDefinition.isEnabled(this.getRootElement().getElementResource().getProject()) && (severity = this.currentRuleDefinition.getMessageSeverities().get(messageId)) != null) {
            return severity;
        }
        return defaultSeverity;
    }
}

