/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.project;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ide.eclipse.core.PersistablePreferenceObjectSupport;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;
import org.springframework.util.StringUtils;

public class ProjectBuilderDefinition
extends PersistablePreferenceObjectSupport {
    private static final Long DEFAULT_ORDER = 10L;
    private static final String BUILDER_PREFIX = "builders.enable.";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ORDER_ATTRIBUTE = "order";
    private String description;
    private String iconUri;
    private String id;
    private String name;
    private String namespaceUri;
    private Long order;
    private IProjectBuilder projectBuilder;

    public ProjectBuilderDefinition(IConfigurationElement element) throws Exception {
        this.init(element);
    }

    private void cleanup(IProject project) {
        if (!this.isEnabled(project)) {
            if (project != null) {
                this.cleanupProject(project);
            } else {
                Set<ISpringProject> projects = SpringCore.getModel().getProjects();
                for (ISpringProject sproject : projects) {
                    IProject p = sproject.getProject();
                    if (this.hasProjectSpecificOptions(p)) continue;
                    this.cleanupProject(p);
                }
            }
        }
    }

    private void cleanupProject(IProject project) {
        try {
            this.getProjectBuilder().cleanup((IResource)project, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    protected String getPreferenceId() {
        return BUILDER_PREFIX + this.id;
    }

    public IProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    public Long getOrder() {
        return this.order;
    }

    private void init(IConfigurationElement element) throws Exception {
        Object builder = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (builder instanceof IProjectBuilder) {
            this.projectBuilder = (IProjectBuilder)builder;
        }
        this.namespaceUri = element.getDeclaringExtension().getNamespaceIdentifier();
        this.id = element.getAttribute(ID_ATTRIBUTE);
        this.name = element.getAttribute(NAME_ATTRIBUTE);
        this.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.iconUri = element.getAttribute(ICON_ATTRIBUTE);
        String orderString = element.getAttribute(ORDER_ATTRIBUTE);
        this.order = StringUtils.hasText((String)orderString) ? Long.valueOf(orderString) : DEFAULT_ORDER;
        String enabledByDefault = element.getAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE);
        if (enabledByDefault != null) {
            this.setEnabledByDefault(Boolean.valueOf(enabledByDefault));
        } else {
            this.setEnabledByDefault(true);
        }
        if (this.projectBuilder instanceof InitializingBean) {
            ((InitializingBean)this.projectBuilder).afterPropertiesSet();
        }
    }

    @Override
    protected void onEnablementChanged(boolean isEnabled, IProject project) {
        this.cleanup(project);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.projectBuilder.getClass().getName() + ")";
    }
}

