/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class SVNPluginAction
extends Action
implements IPluginContribution,
ISelectionChangedListener,
ISelectionListener {
    public static final String ATT_CLASS = "class";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_STATE = "state";
    public static final String ATT_STYLE = "style";
    public static final String ATT_TOOLTIP = "tooltip";
    private IConfigurationElement element;
    private IActionDelegate delegate;
    private String pluginId;

    public SVNPluginAction(IConfigurationElement element) {
        super(element.getAttribute(ATT_LABEL), SVNPluginAction.getStyleFromElement(element));
        ImageDescriptor desc;
        String iconPath;
        this.element = element;
        this.pluginId = element.getContributor().getName();
        this.createDelegate();
        this.setId(element.getAttribute(ATT_ID));
        this.setToolTipText(element.getAttribute(ATT_TOOLTIP));
        if (this.getStyle() == 8 || this.getStyle() == 2) {
            String bool = element.getAttribute(ATT_STATE);
            this.setChecked("true".equals(bool));
        }
        if ((iconPath = element.getAttribute(ATT_ICON)) != null && iconPath.length() > 0 && (desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.pluginId, (String)iconPath)) != null) {
            this.setImageDescriptor(desc);
        }
        this.selectionChanged((ISelection)StructuredSelection.EMPTY);
    }

    private static int getStyleFromElement(IConfigurationElement element) {
        String style = element.getAttribute(ATT_STYLE);
        if ("radio".equals(style)) {
            return 8;
        }
        if ("toggle".equals(style)) {
            return 2;
        }
        return 1;
    }

    public IActionDelegate getDelegate() {
        return this.delegate;
    }

    protected final void createDelegate() {
        if (this.delegate == null) {
            try {
                Object obj = this.element.createExecutableExtension(ATT_CLASS);
                if (obj instanceof IActionDelegate) {
                    this.delegate = (IActionDelegate)obj;
                }
            }
            catch (Throwable e) {
                if (e instanceof CoreException) {
                    SVNUIPlugin.log((CoreException)e);
                }
                SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, "Internal plug-in action delegate error on creation.", e));
            }
        }
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void run() {
        if (this.delegate != null) {
            this.delegate.run((IAction)this);
        }
    }

    public void runWithEvent(Event event) {
        if (event != null && this.delegate instanceof IActionDelegate2) {
            ((IActionDelegate2)this.delegate).runWithEvent((IAction)this, event);
        } else {
            this.run();
        }
    }

    public void dispose() {
        if (this.delegate instanceof IActionDelegate2) {
            ((IActionDelegate2)this.delegate).dispose();
            this.delegate = null;
        }
    }

    public void selectionChanged(ISelection selection) {
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        if (this.delegate != null) {
            this.delegate.selectionChanged((IAction)this, selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(event.getSelection());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.selectionChanged(sel);
    }
}

