/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.svnproperties.SvnPropertiesView;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardSetPropertyPage;

public class SetSvnPropertyAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else if (this.getSelectedResources().length > 0) {
            this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    IResource resource = SetSvnPropertyAction.this.getSelectedResources()[0];
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    SvnWizardSetPropertyPage setPropertyPage = new SvnWizardSetPropertyPage(svnResource);
                    SvnWizard wizard = new SvnWizard(setPropertyPage);
                    SvnWizardDialog dialog = new SvnWizardDialog(SetSvnPropertyAction.this.getShell(), (IWizard)wizard);
                    wizard.setParentDialog((Dialog)dialog);
                    if (dialog.open() != 0) {
                        return;
                    }
                    try {
                        if (setPropertyPage.getPropertyValue() != null) {
                            svnResource.setSvnProperty(setPropertyPage.getPropertyName(), setPropertyPage.getPropertyValue(), setPropertyPage.getRecurse());
                        } else {
                            svnResource.setSvnProperty(setPropertyPage.getPropertyName(), setPropertyPage.getPropertyFile(), setPropertyPage.getRecurse());
                        }
                        SvnPropertiesView.refreshView();
                    }
                    catch (SVNException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, false, 2);
        }
    }

    protected String getErrorTitle() {
        return Policy.bind("SetSvnPropertyAction.set");
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected String getImageId() {
        return "Menu Set Property";
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }
}

