/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.actions;

import java.util.List;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.ui.IEditorPart;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowEditor;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;

public abstract class AbstractBeansEditorPartAction
extends EditorPartAction {
    public AbstractBeansEditorPartAction(IEditorPart editor) {
        super(editor);
    }

    public final boolean calculateEnabled() {
        return this.getBean() != null;
    }

    protected final IBean getBean() {
        IBean bean = null;
        if (this.getFirstSelectedEditPart() != null) {
            Object flowModelElement = this.getFirstSelectedEditPart().getModel();
            String beanId = null;
            IWebflowConfig config = WebflowUtils.getActiveWebflowConfig();
            if (config != null && config.getBeansConfigs() != null && config.getBeansConfigs().size() > 0) {
                Action action;
                if (flowModelElement instanceof Action) {
                    action = (Action)flowModelElement;
                    beanId = action.getBean();
                } else if (flowModelElement instanceof BeanAction) {
                    action = (BeanAction)flowModelElement;
                    beanId = action.getBean();
                } else if (flowModelElement instanceof ExceptionHandler) {
                    action = (ExceptionHandler)flowModelElement;
                    beanId = action.getBean();
                } else if (flowModelElement instanceof AttributeMapper) {
                    action = (AttributeMapper)flowModelElement;
                    beanId = action.getBean();
                }
            }
            if (beanId != null) {
                Set configs = config.getBeansConfigs();
                for (IModelElement bc : configs) {
                    if (BeansModelUtils.getBean((String)beanId, (IModelElement)bc) == null) continue;
                    bean = BeansModelUtils.getBean((String)beanId, (IModelElement)bc);
                    break;
                }
            }
        }
        return bean;
    }

    protected final EditPart getFirstSelectedEditPart() {
        GraphicalViewer viewer = ((WebflowEditor)this.getWorkbenchPart()).getGraphViewer();
        List list = viewer.getSelectedEditParts();
        if (!list.isEmpty()) {
            return (EditPart)list.get(0);
        }
        return null;
    }
}

