/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.IfTransitionCreateCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ReconnectIfTransitionTargetCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ReconnectSourceCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ReconnectTargetCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.StateTransitionCreateCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class StateNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getNewObject() instanceof IStateTransition) {
            if (this.getHost().getModel() instanceof ITransitionableTo) {
                StateTransitionCreateCommand cmd = (StateTransitionCreateCommand)request.getStartCommand();
                ITransitionableFrom source = cmd.getSource();
                ITransitionableTo target = (ITransitionableTo)this.getState();
                if (!(target instanceof IInlineFlowState) && source.getElementParent().equals(target.getElementParent())) {
                    cmd.setTarget((ITransitionableTo)this.getState());
                    return cmd;
                }
                return null;
            }
        } else if (request.getNewObject() instanceof IIfTransition && this.getHost().getModel() instanceof ITransitionableTo) {
            IfTransitionCreateCommand cmd = (IfTransitionCreateCommand)request.getStartCommand();
            cmd.setTarget((ITransitionableTo)this.getState());
            return cmd;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (request.getNewObject() instanceof IStateTransition) {
            if (this.getHost().getModel() instanceof IEndState || this.getHost().getModel() instanceof IActionElement || this.getHost().getModel() instanceof IAttributeMapper || this.getHost().getModel() instanceof IDecisionState || this.getHost().getModel() instanceof IIf || this.getHost().getModel() instanceof IInlineFlowState) {
                return null;
            }
            StateTransitionCreateCommand cmd = new StateTransitionCreateCommand();
            cmd.setSource((ITransitionableFrom)this.getHost().getModel());
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        if (request.getNewObject() instanceof IIfTransition) {
            if (!(this.getHost().getModel() instanceof IIf)) {
                return null;
            }
            if (((IIf)this.getHost().getModel()).getElseTransition() != null) {
                return null;
            }
            IfTransitionCreateCommand cmd = new IfTransitionCreateCommand();
            cmd.setSource((IIf)this.getHost().getModel());
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        return null;
    }

    protected AbstractStatePart getStatePart() {
        return (AbstractStatePart)this.getHost();
    }

    protected IState getState() {
        return (IState)this.getHost().getModel();
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (request.getConnectionEditPart().getModel() instanceof IStateTransition && this.getHost().getModel() instanceof ITransitionableFrom) {
            ReconnectSourceCommand cmd = new ReconnectSourceCommand();
            cmd.setTransition((IStateTransition)request.getConnectionEditPart().getModel());
            cmd.setSource((ITransitionableFrom)this.getState());
            return cmd;
        }
        if (request.getConnectionEditPart().getModel() instanceof IIfTransition) {
            boolean cfr_ignored_0 = this.getHost().getModel() instanceof IIf;
        }
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (request.getConnectionEditPart().getModel() instanceof IStateTransition && this.getHost().getModel() instanceof ITransitionableTo) {
            ReconnectTargetCommand cmd = new ReconnectTargetCommand();
            cmd.setTransition((IStateTransition)request.getConnectionEditPart().getModel());
            cmd.setTarget((ITransitionableTo)this.getState());
            return cmd;
        }
        if (request.getConnectionEditPart().getModel() instanceof IIfTransition && this.getHost().getModel() instanceof ITransitionableTo) {
            ReconnectIfTransitionTargetCommand cmd = new ReconnectIfTransitionTargetCommand();
            cmd.setTransition((IIfTransition)request.getConnectionEditPart().getModel());
            cmd.setTarget((ITransitionableTo)this.getState());
            return cmd;
        }
        return null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        if (target != null && (target.getModel() instanceof IActionElement || target.getModel() instanceof IAttributeMapper)) {
            return null;
        }
        return target instanceof NodeEditPart ? ((NodeEditPart)target).getTargetConnectionAnchor((Request)request) : null;
    }
}

