/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class ActionBeanSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Text beanText;
    private Button browseBeanButton;
    private AbstractAction action;
    private AbstractAction oldAction;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction editAction = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            editAction.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            Action clone = null;
            if (ActionBeanSection.this.action instanceof Action) {
                clone = ((Action)ActionBeanSection.this.action).cloneModelElement();
            } else if (ActionBeanSection.this.action instanceof BeanAction) {
                clone = ((BeanAction)ActionBeanSection.this.action).cloneModelElement();
            }
            clone.setBean(ActionBeanSection.this.beanText.getText());
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)ActionBeanSection.this.action), (IWebflowModelElement)clone);
            if (editAction != null) {
                ActionBeanSection.this.action.removePropertyChangeListener((PropertyChangeListener)ActionBeanSection.this);
                editAction.runWithCommand(command);
                ActionBeanSection.this.action.addPropertyChangeListener((PropertyChangeListener)ActionBeanSection.this);
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.browseBeanButton = this.getWidgetFactory().createButton(composite, "...", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(96, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.browseBeanButton.setLayoutData((Object)data);
        this.browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionBeanSection.this.handleSelectionChanged();
            }
        });
        this.beanText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        this.beanText.setEditable(false);
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment((Control)this.browseBeanButton, 0, 0x1000000);
        this.beanText.setLayoutData((Object)data);
        this.beanText.addModifyListener(this.listener);
        CLabel comboLabel = this.getWidgetFactory().createCLabel(composite, "Bean:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.beanText, -5);
        data.top = new FormAttachment((Control)this.browseBeanButton, 0, 0x1000000);
        comboLabel.setLayoutData((Object)data);
    }

    protected void handleSelectionChanged() {
        ElementListSelectionDialog dialog = DialogUtils.openBeanReferenceDialog(this.beanText.getText(), false);
        if (dialog.open() == 0) {
            this.beanText.setText(((IBean)dialog.getFirstResult()).getElementName());
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldAction != null) {
            this.oldAction.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractStatePart && ((AbstractStatePart)input).getModel() instanceof AbstractAction) {
            this.action = (AbstractAction)((AbstractStatePart)input).getModel();
            this.action.addPropertyChangeListener((PropertyChangeListener)this);
            this.oldAction = this.action;
        }
    }

    public void refresh() {
        this.beanText.removeModifyListener(this.listener);
        if (this.action != null && this.action.getBean() != null) {
            this.beanText.setText(this.action.getBean());
        } else {
            this.beanText.setText("");
        }
        this.beanText.addModifyListener(this.listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.action != null) {
            this.action.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

