/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class AspectResolver {
    private final AspectAdmin aspectAdmin;
    private final ISupplementerRegistry supplementerRegistry;
    private final BundleContext weavingBundleContext;

    public AspectResolver(ISupplementerRegistry supplementerRegistry, AspectAdmin aspectAdmin, BundleContext bundleContext) {
        this.supplementerRegistry = supplementerRegistry;
        this.aspectAdmin = aspectAdmin;
        this.weavingBundleContext = bundleContext;
    }

    private int getApplyAspectsPolicy(ManifestElement[] headers, String manifestValue) {
        int result = 0;
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                if (headers[i].getValue().equals(manifestValue)) {
                    String directive = headers[i].getDirective("apply-aspects");
                    if ("true".equals(directive)) {
                        result = 1;
                    } else if ("false".equals(directive)) {
                        result = 2;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private String getBundleVersion(Bundle bundle) {
        return bundle.getVersion().toString();
    }

    public AspectConfiguration resolveAspectsFor(Bundle bundle, BundleRevision bundleRevision) {
        ArrayList<String> fingerprintElements = new ArrayList<String>();
        List<Definition> definitions = this.resolveAspectsForBundle(fingerprintElements, bundle, bundleRevision);
        Definition[] foundDefinitions = definitions.toArray(new Definition[definitions.size()]);
        Collections.sort(fingerprintElements);
        StringBuilder fingerprint = new StringBuilder();
        for (String element : fingerprintElements) {
            fingerprint.append(element);
            fingerprint.append(';');
        }
        return new AspectConfiguration(bundle, foundDefinitions, fingerprint.toString());
    }

    private List<Definition> resolveAspectsForBundle(List<String> fingerprintElements, Bundle bundle, BundleRevision bundleRevision) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        BundleWiring wiring = bundleRevision.getWiring();
        if (wiring != null && this.weavingBundleContext != null) {
            String finishedValue;
            Definition aspects = null;
            for (BundleWire hostWire : wiring.getProvidedWires("osgi.wiring.host")) {
                Bundle fragmentBundle = hostWire.getRequirer().getBundle();
                if (fragmentBundle == null || (aspects = this.aspectAdmin.getAspectDefinition(fragmentBundle)) == null) continue;
                result.add(aspects);
                fingerprintElements.add(String.valueOf(fragmentBundle.getSymbolicName()) + ":" + hostWire.getRequirer().getVersion().toString());
            }
            List requiredBundles = wiring.getRequiredWires("osgi.wiring.bundle");
            ManifestElement[] requireHeaders = null;
            if (!requiredBundles.isEmpty()) {
                try {
                    requireHeaders = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders("").get("Require-Bundle")));
                }
                catch (BundleException bundleException) {}
            }
            for (BundleWire requiredBundleWire : requiredBundles) {
                int applyPolicy;
                Bundle requiredBundle = requiredBundleWire.getProvider().getBundle();
                if (requiredBundle == null || (aspects = this.aspectAdmin.resolveRequiredBundle(requiredBundle, applyPolicy = this.getApplyAspectsPolicy(requireHeaders, requiredBundle.getSymbolicName()))) == null) continue;
                result.add(aspects);
                fingerprintElements.add(String.valueOf(requiredBundle.getSymbolicName()) + ":" + requiredBundleWire.getProvider().getVersion().toString());
            }
            List importedPackages = wiring.getRequiredWires("osgi.wiring.package");
            ManifestElement[] importHeaders = null;
            if (!importedPackages.isEmpty()) {
                try {
                    importHeaders = ManifestElement.parseHeader((String)"Import-Package", (String)((String)bundle.getHeaders("").get("Import-Package")));
                }
                catch (BundleException bundleException) {}
            }
            for (BundleWire importPackageWire : importedPackages) {
                int applyPolicy;
                String importedPackage;
                Bundle exportingBundle = importPackageWire.getProvider().getBundle();
                if (exportingBundle == null || (aspects = this.aspectAdmin.resolveImportedPackage(exportingBundle, importedPackage = (String)importPackageWire.getCapability().getAttributes().get("osgi.wiring.package"), applyPolicy = this.getApplyAspectsPolicy(importHeaders, importedPackage))) == null) continue;
                result.add(aspects);
                Object v = importPackageWire.getCapability().getAttributes().get("version");
                String version = v == null ? Version.emptyVersion.toString() : v.toString();
                fingerprintElements.add(String.valueOf(importedPackage) + ":" + version);
            }
            Supplementer[] supplementers = this.supplementerRegistry.getSupplementers(bundleRevision.getBundle().getBundleId());
            int i = 0;
            while (i < supplementers.length) {
                aspects = this.aspectAdmin.getExportedAspectDefinitions(supplementers[i].getSupplementerBundle());
                if (aspects != null) {
                    result.add(aspects);
                    fingerprintElements.add(String.valueOf(supplementers[i].getSymbolicName()) + ":" + this.getBundleVersion(supplementers[i].getSupplementerBundle()));
                }
                ++i;
            }
            aspects = this.aspectAdmin.getAspectDefinition(bundle);
            if (!(aspects == null || (finishedValue = (String)bundle.getHeaders("").get("Eclipse-AspectBundle")) != null && "finished".equals(finishedValue))) {
                result.add(aspects);
                fingerprintElements.add(String.valueOf(bundle.getSymbolicName()) + ":" + bundleRevision.getVersion().toString());
            }
        }
        return result;
    }
}

