/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.async;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import reactor.core.publisher.Flux;
import reactor.core.publisher.ReplayProcessor;
import reactor.util.concurrent.QueueSupplier;

public class FluxJdtSearch {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private SearchEngine engine = new SearchEngine();
    private IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
    private SearchPattern pattern = null;
    private SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    private int bufferSize = QueueSupplier.SMALL_BUFFER_SIZE;
    private boolean useSystemJob = false;
    private int jobPriority = 10;

    private static void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public FluxJdtSearch engine(SearchEngine engine) {
        this.engine = engine;
        return this;
    }

    public FluxJdtSearch scope(IJavaSearchScope scope) {
        this.scope = scope;
        return this;
    }

    public FluxJdtSearch scope(IProject project) throws JavaModelException {
        return this.scope(JavaCore.create((IProject)project));
    }

    public FluxJdtSearch scope(IJavaProject project) throws JavaModelException {
        return this.scope(FluxJdtSearch.searchScope(project));
    }

    public FluxJdtSearch bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public FluxJdtSearch pattern(SearchPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public static IJavaSearchScope searchScope(IJavaProject javaProject, boolean includeBinaries) throws JavaModelException {
        int includeMask = 9;
        if (includeBinaries) {
            includeMask |= 2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)includeMask);
    }

    public static IJavaSearchScope searchScope(IJavaProject javaProject) throws JavaModelException {
        return FluxJdtSearch.searchScope(javaProject, true);
    }

    protected SearchEngine searchEngine() {
        return new SearchEngine();
    }

    protected SearchParticipant[] participants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    public Flux<SearchMatch> search() {
        this.validate();
        if (this.scope == null) {
            return Flux.empty();
        }
        final FluxSearchRequestor requestor = new FluxSearchRequestor();
        Job job = new Job("Search for " + this.pattern){

            protected IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                FluxJdtSearch.debug("Starting search for '" + FluxJdtSearch.this.pattern + "'");
                try {
                    FluxJdtSearch.this.searchEngine().search(FluxJdtSearch.this.pattern, FluxJdtSearch.this.participants, FluxJdtSearch.this.scope, (SearchRequestor)requestor, monitor);
                    requestor.done();
                }
                catch (Exception e) {
                    FluxJdtSearch.debug("Canceled search for: " + FluxJdtSearch.this.pattern);
                    FluxJdtSearch.debug("          exception: " + ExceptionUtil.getMessage((Throwable)e));
                    long duration = System.currentTimeMillis() - start;
                    FluxJdtSearch.debug("          duration: " + duration + " ms");
                    requestor.cancel();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(this.useSystemJob);
        job.setPriority(this.jobPriority);
        job.schedule();
        return requestor.asFlux();
    }

    private void validate() {
        Assert.isNotNull((Object)this.engine, (String)"engine");
        Assert.isNotNull((Object)this.pattern, (String)"pattern");
        Assert.isNotNull((Object)this.participants, (String)"participants");
        Assert.isLegal((this.bufferSize > 0 ? 1 : 0) != 0);
    }

    public static IJavaSearchScope workspaceScope(boolean includeBinaries) {
        if (includeBinaries) {
            return SearchEngine.createWorkspaceScope();
        }
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                if (p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jp = JavaCore.create((IProject)p);
                    projects.add(jp);
                }
            }
            catch (Exception e) {
                FrameworkCoreActivator.log(e);
            }
            ++n2;
        }
        int includeMask = 1;
        return SearchEngine.createJavaSearchScope((IJavaElement[])projects.toArray(new IJavaElement[projects.size()]), (int)includeMask);
    }

    class FluxSearchRequestor
    extends SearchRequestor {
        private boolean isCanceled = false;
        private ReplayProcessor<SearchMatch> emitter;
        private Flux<SearchMatch> flux;

        FluxSearchRequestor() {
            this.emitter = ReplayProcessor.create((int)FluxJdtSearch.this.bufferSize).connect();
            this.flux = this.emitter.doOnCancel(() -> {
                boolean bl = this.isCanceled = true;
            });
        }

        public Flux<SearchMatch> asFlux() {
            return this.flux;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.isCanceled) {
                FluxJdtSearch.debug("!!!! canceling search !!!!");
                throw new OperationCanceledException();
            }
            this.emitter.onNext((Object)match);
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public void done() {
            this.emitter.onComplete();
        }
    }
}

