/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.swt.widgets.Display;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.SimpleDownloadService;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.util.FileUtil;

public class DownloadManager {
    private final File cacheDirectory;
    private final DownloadService downloader;
    private boolean deleteCacheOnDispose = false;
    private boolean allowUIThread = false;
    private int tries = 5;
    private long retryInterval = 0L;

    public DownloadManager(DownloadService downloader, File cacheDir) throws IOException {
        if (cacheDir == null) {
            cacheDir = FileUtil.createTempDirectory("downloadCache");
            this.deleteCacheOnDispose = true;
        }
        if (downloader == null) {
            downloader = new SimpleDownloadService();
        }
        this.downloader = downloader;
        this.cacheDirectory = cacheDir;
        if (!cacheDir.isDirectory()) {
            Assert.isTrue((boolean)cacheDir.mkdirs(), (String)("Couldn't create cache directory at " + cacheDir));
        }
    }

    public DownloadManager clearCache() {
        FileUtils.deleteQuietly((File)this.cacheDirectory);
        this.cacheDirectory.mkdirs();
        return this;
    }

    @Deprecated
    public DownloadManager() throws IOException {
        this(new URLConnectionFactory());
    }

    public DownloadManager(URLConnectionFactory urlConnectionFactory) throws IOException {
        this(new SimpleDownloadService(urlConnectionFactory), null);
        this.deleteCacheOnDispose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public File downloadFile(DownloadableItem item) throws URISyntaxException, FileNotFoundException, CoreException, IOException, UIThreadDownloadDisallowed {
        File target = this.getLocalLocation(item);
        if (target.exists()) {
            return target;
        }
        if (!this.allowUIThread && Display.getCurrent() != null) {
            throw new UIThreadDownloadDisallowed("Don't call download manager from the UI Thread unless the data is already cached.");
        }
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            if (target.exists()) {
                return target;
            }
            if (!this.cacheDirectory.exists()) {
                this.cacheDirectory.mkdirs();
            }
            File targetPart = new File(String.valueOf(target.toString()) + ".part");
            try (FileOutputStream out = new FileOutputStream(targetPart);){
                URL url = item.getURL();
                System.out.println("Downloading " + url + " to " + target);
                this.downloader.fetch(url, out);
            }
            if (!targetPart.renameTo(target)) {
                throw new IOException("Error while renaming " + targetPart + " to " + target);
            }
            return target;
        }
    }

    public File getLocalLocation(DownloadableItem item) {
        URL url = item.getURL();
        String protocol = url.getProtocol();
        try {
            if ("file".equals(protocol)) {
                return new File(URIUtil.toURI((URL)url));
            }
        }
        catch (URISyntaxException e) {
            FrameworkCoreActivator.log(e);
        }
        String filename = item.getFileName();
        File target = new File(this.cacheDirectory, filename);
        return target;
    }

    public void doWithDownload(DownloadableItem target, DownloadRequestor action) throws Exception {
        int tries = this.getTries();
        Throwable e = null;
        File downloadedFile = null;
        while (true) {
            --tries;
            try {
                downloadedFile = this.downloadFile(target);
                action.exec(downloadedFile);
                return;
            }
            catch (UIThreadDownloadDisallowed caught) {
                throw caught;
            }
            catch (Throwable caught) {
                FrameworkCoreActivator.log(caught);
                if (downloadedFile != null) {
                    downloadedFile.delete();
                    downloadedFile = null;
                }
                e = caught;
                if (tries <= 0 || this.retryInterval <= 0L) continue;
                Thread.sleep(this.retryInterval);
                if (tries > 0) continue;
                throw ExceptionUtil.exception(e);
            }
            break;
        }
    }

    public int getTries() {
        return this.tries;
    }

    public DownloadManager setTries(int r) {
        Assert.isLegal((r > 1 ? 1 : 0) != 0);
        this.tries = r;
        return this;
    }

    public void setRetryInterval(long retryInterval) {
        Assert.isLegal((retryInterval >= 0L ? 1 : 0) != 0);
        this.retryInterval = retryInterval;
    }

    public long getRetryInterval(long retryInterval) {
        return retryInterval;
    }

    public File getCacheDir() {
        return this.cacheDirectory;
    }

    public boolean isDownloaded(DownloadableItem item) {
        File target = this.getLocalLocation(item);
        return target != null && target.exists();
    }

    public void dispose() {
        if (this.deleteCacheOnDispose) {
            FileUtils.deleteQuietly((File)this.cacheDirectory);
            this.deleteCacheOnDispose = false;
        }
    }

    public DownloadManager allowUIThread(boolean allow) {
        this.allowUIThread = allow;
        return this;
    }

    public static interface DownloadRequestor {
        public void exec(File var1) throws Exception;
    }

    public static interface DownloadService {
        public void fetch(URL var1, OutputStream var2) throws IOException;
    }
}

