/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static void pipe(InputStream data, File target) throws IOException {
        target.getParentFile().mkdirs();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
            IOUtil.pipe(data, out);
        }
    }

    public static void pipe(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int n = input.read(buf);
            while (n >= 0) {
                output.write(buf, 0, n);
                n = input.read(buf);
            }
            output.flush();
        }
        finally {
            input.close();
        }
    }

    public static String toString(InputStream input) throws Exception {
        return IOUtil.toString(input, "UTF8");
    }

    private static String toString(InputStream input, String encoding) throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        IOUtil.pipe(input, buf);
        return buf.toString(encoding);
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtil.pipe(stream, bytes);
        return bytes.toByteArray();
    }
}

