/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;

public class JobUtil {
    public static final IRunnableContext DEFAULT_BACKGROUND_RUNNABLE_CONTEXT = new IRunnableContext(){

        public void run(boolean arg0, boolean arg1, final IRunnableWithProgress runnableWithProgress) throws InvocationTargetException, InterruptedException {
            if (runnableWithProgress != null) {
                Job job = new Job("Running a background job."){

                    public IStatus run(IProgressMonitor monitor) {
                        try {
                            runnableWithProgress.run(monitor);
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            return UIJob.errorStatus((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    };

    public static ISchedulingRule lightRule(final String name) {
        return new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this || rule.contains((ISchedulingRule)this);
            }

            public String toString() {
                return name;
            }
        };
    }

    public static void runBackgroundJobWithUIProgress(final IRunnableWithProgress runnableWithProgress, IRunnableContext progressService, final String jobLabel) throws Exception {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(jobLabel, -1);
                Job job = new Job(jobLabel){

                    public IStatus run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                        subMonitor.setTaskName(jobLabel);
                        try {
                            try {
                                runnableWithProgress.run((IProgressMonitor)subMonitor);
                            }
                            catch (Throwable e) {
                                FrameworkCoreActivator.log(e);
                                subMonitor.done();
                            }
                        }
                        finally {
                            subMonitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        };
        Exception[] error = new Exception[1];
        Display.getDefault().syncExec(() -> {
            try {
                progressService.run(true, true, outerRunnable);
            }
            catch (InvocationTargetException e) {
                exceptionArray[0] = e;
            }
            catch (InterruptedException e) {
                exceptionArray[0] = e;
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
    }
}

