/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.workspace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;

public class ProjectDeletionListenerManager
implements IResourceChangeListener {
    private IWorkspace workspace;
    private ProjectDeletionListener listener;

    public ProjectDeletionListenerManager(IWorkspace workspace, ProjectDeletionListener listener) {
        this.workspace = workspace;
        this.listener = listener;
        this.workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] children;
        IResourceDelta _delta = event.getDelta();
        if (_delta != null && (children = _delta.getAffectedChildren()) != null) {
            IResourceDelta[] iResourceDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                int kind;
                IResource rsrc;
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta != null && (rsrc = delta.getResource()) instanceof IProject && (kind = delta.getKind()) == 2 && !this.isRename(delta)) {
                    this.listener.projectWasDeleted((IProject)rsrc);
                }
                ++n2;
            }
        }
    }

    private boolean isRename(IResourceDelta delta) {
        return (delta.getFlags() & 0x2000) != 0;
    }

    public void dispose() {
        if (this.listener != null) {
            this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
            this.listener = null;
        }
    }

    public static interface ProjectDeletionListener {
        public void projectWasDeleted(IProject var1);
    }
}

