/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.autowire.IAutowireDependencyResolver;
import org.springframework.ide.eclipse.beans.core.autowire.IFactoryBeanTypeResolver;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowireUtils;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowiredAnnotationInjectionMetadataProvider;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.CommonAnnnotationInjectionMetadataProvider;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.FactoryBeanTypeResolverExtensions;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProvider;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProviderProblemReporter;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.InjectionMetadata;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AutowireDependencyProvider
implements IAutowireDependencyResolver {
    public static final String TOO_MANY_MATCHING_BEANS = "TOO_MANY_MATCHING_BEANS";
    public static final String REQUIRED_NO_MATCH = "REQUIRED_NO_MATCH";
    public static final String AUTOWIRE_PROBLEM_TYPE = "AUTOWIRE_PROBLEM";
    public static final String MATCHING_BEAN_NAME = "MATCHING_BEAN_NAME";
    public static final String BEAN_TYPE = "BEAN_TYPE";
    private Set<IBean> beans;
    private IBeansModelElement context;
    private IBeansModelElement element;
    private IBeansProject project;
    private IProjectClassLoaderSupport classLoaderSupport;
    private Map<IBean, List<InjectionMetadata>> injectionMetadata = new ConcurrentHashMap<IBean, List<InjectionMetadata>>();
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private IInjectionMetadataProviderProblemReporter problemReporter = new AutowireProblemReporter();
    private List<ValidationProblem> problems = new ArrayList<ValidationProblem>();
    private Map<Class<?>, String> resolvableDependencies = new HashMap();
    private Class<?> factoryBeanClass;
    private Class<?> objectFactoryClass;
    private Class<?> providerClass;

    public AutowireDependencyProvider(IBeansModelElement element, IBeansModelElement context) {
        this.context = context == null ? element : context;
        this.element = element;
        this.beans = BeansModelUtils.getBeans((IModelElement)context);
        this.project = (IBeansProject)BeansModelUtils.getParentOfClass((IModelElement)context, IBeansProject.class);
    }

    public List<ValidationProblem> getValidationProblems() {
        return this.problems;
    }

    public Map<IBean, Set<IBeanReference>> resolveAutowiredDependencies() {
        final HashMap<IBean, Set<IBeanReference>> autowiredBeanReferences = new HashMap<IBean, Set<IBeanReference>>();
        this.createProjectClassLoaderSupport();
        try {
            this.classLoaderSupport.executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                public void doWithActiveProjectClassLoader() throws Throwable {
                    AutowireDependencyProvider.this.preloadClasses();
                    this.fillResolvableDependencies();
                    Set elementBeans = BeansModelUtils.getBeans((IModelElement)AutowireDependencyProvider.this.element);
                    for (IInjectionMetadataProvider iInjectionMetadataProvider : AutowireDependencyProvider.this.createInjectionMetadataProviders()) {
                        for (IBean bean : elementBeans) {
                            List<InjectionMetadata> beanInjectionMetadata = null;
                            if (AutowireDependencyProvider.this.injectionMetadata.containsKey(bean)) {
                                beanInjectionMetadata = (List)AutowireDependencyProvider.this.injectionMetadata.get(bean);
                            } else {
                                beanInjectionMetadata = new ArrayList();
                                AutowireDependencyProvider.this.injectionMetadata.put(bean, beanInjectionMetadata);
                            }
                            String className = BeansModelUtils.getBeanClass((IBean)bean, (IModelElement)AutowireDependencyProvider.this.context);
                            try {
                                if (className == null || bean.isFactory()) continue;
                                Class targetClass = ClassUtils.loadClass((String)className);
                                beanInjectionMetadata.add(iInjectionMetadataProvider.findAutowiringMetadata(targetClass));
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    for (Map.Entry entry : AutowireDependencyProvider.this.injectionMetadata.entrySet()) {
                        HashSet<IBeanReference> autowiredReferences = new HashSet<IBeanReference>();
                        for (InjectionMetadata metadata : (List)entry.getValue()) {
                            this.resolveDependencies((IBean)entry.getKey(), autowiredReferences, metadata.getInjectedFields());
                            this.resolveDependencies((IBean)entry.getKey(), autowiredReferences, metadata.getInjectedMethods());
                            this.resolveConstructorDependencies((IBean)entry.getKey(), autowiredReferences, metadata.getInjectedConstructors());
                        }
                        if (autowiredReferences.size() <= 0) continue;
                        autowiredBeanReferences.put((IBean)entry.getKey(), autowiredReferences);
                    }
                }

                private void fillResolvableDependencies() {
                    this.addResolvableClass(BeanFactory.class.getName());
                    this.addResolvableClass("org.springframework.core.io.ResourceLoader");
                    this.addResolvableClass("org.springframework.context.ApplicationEventPublisher");
                    this.addResolvableClass("org.springframework.context.ApplicationContext");
                    this.addResolvableClass("org.springframework.core.env.Environment", "environment");
                    this.addResolvableClass("javax.servlet.ServletConfig");
                    this.addResolvableClass("javax.servlet.ServletRequest", "requestObjectFactory");
                    this.addResolvableClass("javax.servlet.http.HttpSession", "sessionObjectFactory");
                    this.addResolvableClass("javax.portlet.PortletRequest", "requestObjectFactory");
                    this.addResolvableClass("javax.portlet.PortletSession", "sessionObjectFactory");
                    this.addResolvableClass("javax.portlet.PortletSession", "sessionObjectFactory");
                }

                private void addResolvableClass(String className, String beanName) {
                    try {
                        Class clazz = ClassUtils.loadClass((String)className);
                        AutowireDependencyProvider.this.resolvableDependencies.put(clazz, beanName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }

                private void addResolvableClass(String className) {
                    this.addResolvableClass(className, StringUtils.uncapitalize((String)org.springframework.util.ClassUtils.getShortName((String)className)));
                }

                private void resolveConstructorDependencies(IBean bean, Set<IBeanReference> autowiredReferences, Set<InjectionMetadata.InjectedElement> injectedConstructors) {
                    InjectionMetadata.InjectedElement[] constructors = this.sortConstructors(injectedConstructors);
                    if (constructors.length > 0) {
                        InjectionMetadata.InjectedElement[] injectedElementArray = constructors;
                        int n = constructors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            InjectionMetadata.InjectedElement injectionElement = injectedElementArray[n2];
                            try {
                                autowiredReferences.addAll(injectionElement.getBeanReferences(bean, AutowireDependencyProvider.this.context, AutowireDependencyProvider.this));
                            }
                            catch (Throwable throwable) {}
                            ++n2;
                        }
                    }
                }

                private InjectionMetadata.InjectedElement[] sortConstructors(Set<InjectionMetadata.InjectedElement> injectedConstructors) {
                    InjectionMetadata.InjectedElement[] constructors = injectedConstructors.toArray(new InjectionMetadata.InjectedElement[injectedConstructors.size()]);
                    Arrays.sort(constructors, new Comparator<InjectionMetadata.InjectedElement>(){

                        @Override
                        public int compare(InjectionMetadata.InjectedElement o1, InjectionMetadata.InjectedElement o2) {
                            boolean p2;
                            Constructor c1 = (Constructor)o1.getMember();
                            Constructor c2 = (Constructor)o2.getMember();
                            boolean p1 = Modifier.isPublic(c1.getModifiers());
                            if (p1 != (p2 = Modifier.isPublic(c2.getModifiers()))) {
                                return p1 ? -1 : 1;
                            }
                            int c1pl = c1.getParameterTypes().length;
                            int c2pl = c2.getParameterTypes().length;
                            return new Integer(c1pl).compareTo(c2pl) * -1;
                        }
                    });
                    return constructors;
                }

                private void resolveDependencies(IBean bean, Set<IBeanReference> autowiredReferences, Set<InjectionMetadata.InjectedElement> injectionElements) {
                    if (injectionElements.size() > 0) {
                        for (InjectionMetadata.InjectedElement injectionElement : injectionElements) {
                            try {
                                autowiredReferences.addAll(injectionElement.getBeanReferences(bean, AutowireDependencyProvider.this.context, AutowireDependencyProvider.this));
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable e) {
            BeansCorePlugin.log((Throwable)e);
        }
        return autowiredBeanReferences;
    }

    public void preloadClasses() {
        try {
            this.factoryBeanClass = ClassUtils.loadClass((String)FactoryBean.class.getName());
        }
        catch (Throwable throwable) {}
        try {
            this.objectFactoryClass = ClassUtils.loadClass((String)ObjectFactory.class.getName());
        }
        catch (Throwable throwable) {}
        try {
            this.providerClass = ClassUtils.loadClass((String)Provider.class.getName());
        }
        catch (Throwable throwable) {}
    }

    @Override
    public boolean containsBean(String beanName) {
        return this.getBean(beanName) != null;
    }

    @Override
    public String[] getAliases(String beanName) {
        HashSet<String> aliases;
        block3: {
            block2: {
                aliases = new HashSet<String>();
                if (!(this.context instanceof IBeansConfig)) break block2;
                for (IBeanAlias alias : ((IBeansConfig)this.context).getAliases()) {
                    if (!beanName.equals(alias.getBeanName())) continue;
                    aliases.add(alias.getElementName());
                }
                break block3;
            }
            if (!(this.context instanceof IBeansConfigSet)) break block3;
            for (IBeanAlias alias : ((IBeansConfigSet)this.context).getAliases()) {
                if (!beanName.equals(alias.getBeanName())) continue;
                aliases.add(alias.getElementName());
            }
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    public IBean getBean(String candidateName) {
        for (IBean bean : this.beans) {
            if (bean.getElementName().equals(candidateName)) {
                return bean;
            }
            String[] stringArray = this.getAliases(bean.getElementName());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (alias.equals(candidateName)) {
                    return bean;
                }
                ++n2;
            }
        }
        return null;
    }

    public String[] getBeansForType(String requiredTypeName) {
        try {
            Class requiredType = ClassUtils.loadClass((String)requiredTypeName);
            return this.getBeansForType(requiredType);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable e) {
            BeansCorePlugin.log((Throwable)e);
        }
        return new String[0];
    }

    @Override
    public String[] getBeansForType(Class<?> requiredType) {
        HashSet<String> matchingBeans = new HashSet<String>();
        for (IBean bean : this.beans) {
            String beanClassName = ValidationRuleUtils.getBeanClassName((IBean)bean, (IModelElement)this.context);
            if (beanClassName == null) continue;
            try {
                Class beanClass = ClassUtils.loadClass((String)beanClassName);
                if (requiredType.isAssignableFrom(beanClass)) {
                    matchingBeans.add(bean.getElementName());
                    continue;
                }
                if (this.factoryBeanClass == null || !this.factoryBeanClass.isAssignableFrom(beanClass)) continue;
                if (this.isFactoryForType(beanClass, requiredType)) {
                    matchingBeans.add(bean.getElementName());
                    continue;
                }
                if (!this.isExtensibleFactoryForType(bean, beanClass, requiredType)) continue;
                matchingBeans.add(bean.getElementName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Throwable e) {
                BeansCorePlugin.log((Throwable)e);
            }
        }
        return matchingBeans.toArray(new String[matchingBeans.size()]);
    }

    private boolean isFactoryForType(Class<?> beanClass, Class<?> requiredType) {
        try {
            Method factoryMethod = beanClass.getMethod("getObject", new Class[0]);
            if (factoryMethod != null && requiredType.isAssignableFrom(factoryMethod.getReturnType())) {
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable e) {
            BeansCorePlugin.log((Throwable)e);
        }
        return false;
    }

    private boolean isExtensibleFactoryForType(IBean bean, Class<?> beanClass, Class<?> requiredType) {
        IFactoryBeanTypeResolver[] resolvers;
        IFactoryBeanTypeResolver[] iFactoryBeanTypeResolverArray = resolvers = FactoryBeanTypeResolverExtensions.getFactoryBeanTypeResolvers();
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            IFactoryBeanTypeResolver factoryTypeResolver = iFactoryBeanTypeResolverArray[n2];
            Class<?> beanType = factoryTypeResolver.resolveBeanTypeFromFactory(bean, beanClass);
            if (beanType != null && requiredType.isAssignableFrom(beanType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        boolean isFactoryBean;
        boolean bl = isFactoryBean = descriptor != null && descriptor.getDependencyType() != null && this.factoryBeanClass != null && this.factoryBeanClass.isAssignableFrom(descriptor.getDependencyType());
        if (isFactoryBean) {
            beanName = BeanFactoryUtils.transformedBeanName((String)beanName);
        }
        if (this.containsBean(beanName)) {
            return this.isAutowireCandidate(beanName, BeansModelUtils.getMergedBeanDefinition((IBean)this.getBean(beanName), (IModelElement)this.context), descriptor);
        }
        return true;
    }

    private Set<IInjectionMetadataProvider> createInjectionMetadataProviders() {
        String[] commonAnnotationBeanPostProcessorNames;
        String[] autowiredAnnotationBeanPostProcessorNames;
        HashSet<IInjectionMetadataProvider> providers = new HashSet<IInjectionMetadataProvider>();
        String[] stringArray = autowiredAnnotationBeanPostProcessorNames = this.getBeansForType(AutowiredAnnotationBeanPostProcessor.class.getName());
        int n = autowiredAnnotationBeanPostProcessorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String autowiredAnnotationBeanPostProcessorName = stringArray[n2];
            AutowiredAnnotationInjectionMetadataProvider provider = new AutowiredAnnotationInjectionMetadataProvider(this.classLoaderSupport.getProjectClassLoader());
            IBean bean = this.getBean(autowiredAnnotationBeanPostProcessorName);
            BeanDefinition beanDef = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)this.context);
            if (beanDef.getPropertyValues().size() > 0) {
                BeanWrapperImpl wrapper = new BeanWrapperImpl(true);
                wrapper.setConversionService((ConversionService)new DefaultConversionService());
                wrapper.setWrappedInstance((Object)provider);
                for (PropertyValue pv : beanDef.getPropertyValues().getPropertyValueList()) {
                    if (!wrapper.isWritableProperty(pv.getName()) || !(pv.getValue() instanceof TypedStringValue)) continue;
                    wrapper.setPropertyValue(pv.getName(), (Object)((TypedStringValue)pv.getValue()).getValue());
                }
            }
            provider.setProblemReporter(this.problemReporter);
            providers.add(provider);
            ++n2;
        }
        String[] stringArray2 = commonAnnotationBeanPostProcessorNames = this.getBeansForType(CommonAnnotationBeanPostProcessor.class.getName());
        int n3 = commonAnnotationBeanPostProcessorNames.length;
        n = 0;
        while (n < n3) {
            String commonAnnotationBeanPostProcessorName = stringArray2[n];
            CommonAnnnotationInjectionMetadataProvider provider = new CommonAnnnotationInjectionMetadataProvider();
            IBean bean = this.getBean(commonAnnotationBeanPostProcessorName);
            BeanDefinition beanDef = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)this.context);
            if (beanDef.getPropertyValues().size() > 0) {
                BeanWrapperImpl wrapper = new BeanWrapperImpl(true);
                wrapper.setConversionService((ConversionService)new DefaultConversionService());
                wrapper.setWrappedInstance((Object)provider);
                for (PropertyValue pv : beanDef.getPropertyValues().getPropertyValueList()) {
                    if (!wrapper.isWritableProperty(pv.getName()) || !(pv.getValue() instanceof TypedStringValue)) continue;
                    wrapper.setPropertyValue(pv.getName(), (Object)((TypedStringValue)pv.getValue()).getValue());
                }
            }
            provider.setProblemReporter(this.problemReporter);
            providers.add(provider);
            ++n;
        }
        return providers;
    }

    private AutowireCandidateResolver getAutowireCandidateResolver() {
        QualifierAnnotationAutowireCandidateResolver resolver = new QualifierAnnotationAutowireCandidateResolver(this.classLoaderSupport.getProjectClassLoader());
        resolver.setProblemReporter(this.problemReporter);
        return resolver;
    }

    protected void createProjectClassLoaderSupport() {
        if (this.classLoaderSupport == null) {
            this.classLoaderSupport = JdtUtils.getProjectClassLoaderSupport((IProject)this.project.getProject(), null);
        }
    }

    public void setProjectClassLoaderSupport(IProjectClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
    }

    protected String determinePrimaryCandidate(Map<String, IBean> candidateBeans, DependencyDescriptor descriptor) {
        String primaryBeanName = null;
        String fallbackBeanName = null;
        for (Map.Entry<String, IBean> entry : candidateBeans.entrySet()) {
            IBean beanInstance;
            String candidateBeanName = entry.getKey();
            if (this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) {
                if (primaryBeanName != null) {
                    boolean primaryLocal;
                    boolean candidateLocal = this.containsBean(candidateBeanName);
                    if (candidateLocal == (primaryLocal = this.containsBean(primaryBeanName))) {
                        this.problemReporter.error("More than one 'primary' bean found among candiates [" + candidateBeans.keySet() + "]", descriptor, new ValidationProblemAttribute[0]);
                        throw new AutowireResolutionException();
                    }
                    if (candidateLocal && !primaryLocal) {
                        primaryBeanName = candidateBeanName;
                    }
                } else {
                    primaryBeanName = candidateBeanName;
                }
            }
            if (primaryBeanName != null || !this.matchesBeanName(candidateBeanName, descriptor.getDependencyName())) continue;
            fallbackBeanName = candidateBeanName;
        }
        return primaryBeanName != null ? primaryBeanName : fallbackBeanName;
    }

    protected void doResolveDependency(DependencyDescriptor descriptor, Class<?> type, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            Map<String, IBean> matchingBeans = this.findAutowireCandidates(beanName, componentType, descriptor);
            if (matchingBeans.isEmpty() && descriptor.isRequired()) {
                this.problemReporter.error("No matching beans found for 'required' dependency array", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
        } else if (Collection.class.isAssignableFrom(type) && type.isInterface()) {
            Class elementType = descriptor.getCollectionType();
            if (elementType == null && descriptor.isRequired()) {
                this.problemReporter.error("No element type declared for 'required' collection [" + type.getName() + "]", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            Map<String, IBean> matchingBeans = this.findAutowireCandidates(beanName, elementType, descriptor);
            if (matchingBeans.isEmpty() && descriptor.isRequired()) {
                this.problemReporter.error("No matching beans found for 'required' dependency collection", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
        } else if (Map.class.isAssignableFrom(type) && type.isInterface()) {
            Class keyType = descriptor.getMapKeyType();
            if ((keyType == null || !String.class.isAssignableFrom(keyType)) && descriptor.isRequired()) {
                this.problemReporter.error("Key type [" + keyType + "] of map [" + type.getName() + "] must be assignable to [java.lang.String]", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            Class valueType = descriptor.getMapValueType();
            if (valueType == null && descriptor.isRequired()) {
                this.problemReporter.error("No value type declared for 'required' map [" + type.getName() + "]", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            Map<String, IBean> matchingBeans = this.findAutowireCandidates(beanName, valueType, descriptor);
            if (matchingBeans.isEmpty() && descriptor.isRequired()) {
                this.problemReporter.error("No matching beans found for 'required' dependency map for value type [" + valueType.getName() + "]", descriptor, new ValidationProblemAttribute[0]);
                throw new AutowireResolutionException();
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
        } else {
            Map<String, IBean> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.problemReporter.error("Unsatisfied 'required' dependency of type [" + type + "]. Expected at least 1 matching bean", descriptor, new ValidationProblemAttribute(AUTOWIRE_PROBLEM_TYPE, (Object)REQUIRED_NO_MATCH));
                    throw new AutowireResolutionException();
                }
                return;
            }
            if (matchingBeans.size() > 1) {
                String primaryBeanName = this.determinePrimaryCandidate(matchingBeans, descriptor);
                if (primaryBeanName == null) {
                    Set<String> matchingBeanNames = matchingBeans.keySet();
                    ValidationProblemAttribute[] attributes = new ValidationProblemAttribute[matchingBeanNames.size() + 2];
                    attributes[0] = new ValidationProblemAttribute(AUTOWIRE_PROBLEM_TYPE, (Object)TOO_MANY_MATCHING_BEANS);
                    attributes[1] = new ValidationProblemAttribute(BEAN_TYPE, (Object)type.getName());
                    int counter = 2;
                    for (String matchingBeanName : matchingBeanNames) {
                        attributes[counter] = new ValidationProblemAttribute(MATCHING_BEAN_NAME + counter, (Object)matchingBeanName);
                        ++counter;
                    }
                    this.problemReporter.error("Expected single matching bean but found " + matchingBeans.size() + ": " + matchingBeanNames, descriptor, attributes);
                    throw new AutowireResolutionException();
                }
                if (autowiredBeanNames != null) {
                    autowiredBeanNames.add(primaryBeanName);
                    return;
                }
            }
            Map.Entry<String, IBean> entry = matchingBeans.entrySet().iterator().next();
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(entry.getKey());
            }
        }
    }

    protected Map<String, IBean> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = this.getBeansForType(requiredType);
        LinkedHashMap<String, IBean> result = new LinkedHashMap<String, IBean>(candidateNames.length);
        for (Class<?> autowiringType : this.resolvableDependencies.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            String autowiringValue = this.resolvableDependencies.get(autowiringType);
            result.put(autowiringValue, null);
            break;
        }
        String[] stringArray = candidateNames;
        int n = candidateNames.length;
        int n2 = 0;
        while (n2 < n) {
            String candidateName = stringArray[n2];
            if (!candidateName.equals(beanName) && this.isAutowireCandidate(candidateName, descriptor)) {
                result.put(candidateName, this.getBean(candidateName));
            }
            ++n2;
        }
        return result;
    }

    protected boolean isAutowireCandidate(String beanName, BeanDefinition mbd, DependencyDescriptor descriptor) {
        return this.getAutowireCandidateResolver().isAutowireCandidate(new BeanDefinitionHolder(mbd, beanName, this.getAliases(beanName)), descriptor);
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        if (this.containsBean(beanName)) {
            return BeansModelUtils.getMergedBeanDefinition((IBean)this.getBean(beanName), (IModelElement)this.context).isPrimary();
        }
        return false;
    }

    protected boolean matchesBeanName(String beanName, String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement((Object[])this.getAliases(beanName), (Object)candidateName));
    }

    @Override
    public void resolveDependency(DependencyDescriptor descriptor, Class<?> type, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) {
        descriptor.initParameterNameDiscovery(this.parameterNameDiscoverer);
        if (descriptor.getDependencyType().equals(this.objectFactoryClass) || descriptor.getDependencyType().equals(this.providerClass)) {
            descriptor.increaseNestingLevel();
            type = descriptor.getDependencyType();
        }
        try {
            this.doResolveDependency(descriptor, type, beanName, autowiredBeanNames, typeConverter);
        }
        catch (AutowireResolutionException autowireResolutionException) {}
    }

    private class AutowireProblemReporter
    implements IInjectionMetadataProviderProblemReporter {
        private AutowireProblemReporter() {
        }

        @Override
        public void error(String message, Member member, ValidationProblemAttribute ... attributes) {
            try {
                IJavaElement source = AutowireUtils.getJavaElement((IResource)AutowireDependencyProvider.this.project.getProject(), member, -1);
                if (source != null && source.getUnderlyingResource() != null) {
                    ValidationProblemAttribute[] newAttributes = new ValidationProblemAttribute[attributes.length + 1];
                    int i = 0;
                    while (i < attributes.length) {
                        newAttributes[i] = attributes[i];
                        ++i;
                    }
                    newAttributes[attributes.length] = new ValidationProblemAttribute("JAVA_HANDLE", (Object)source.getHandleIdentifier());
                    AutowireDependencyProvider.this.problems.add(new ValidationProblem(1, message, source.getUnderlyingResource(), JdtUtils.getLineNumber((IJavaElement)source), newAttributes));
                }
            }
            catch (JavaModelException javaModelException) {}
        }

        @Override
        public void error(String message, DependencyDescriptor descriptor, ValidationProblemAttribute ... attributes) {
            if (descriptor.getField() != null) {
                this.error(message, descriptor.getField(), attributes);
            } else if (descriptor.getMethodParameter() != null && descriptor.getMethodParameter().getMethod() != null) {
                this.error(message, descriptor.getMethodParameter().getMethod(), attributes);
            } else if (descriptor.getMethodParameter() != null && descriptor.getMethodParameter().getConstructor() != null) {
                this.error(message, descriptor.getMethodParameter().getConstructor(), attributes);
            }
        }
    }

    private static class AutowireResolutionException
    extends RuntimeException {
        private AutowireResolutionException() {
        }
    }
}

