/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.completions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInformationControlCreator;
import org.springframework.ide.eclipse.editor.support.hover.YPropertyHoverInfo;
import org.springframework.ide.eclipse.editor.support.util.ColorManager;
import org.springframework.ide.eclipse.editor.support.yaml.completions.AbstractPropertyProposal;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;
import org.springframework.util.StringUtils;

public class CompletionFactory {
    public static final StyledString.Styler HIGHLIGHT = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ColorManager.getInstance().getColor(ColorManager.CYAN);
        }
    };
    public static final StyledString.Styler DEPRECATE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    };
    public static final StyledString.Styler DEEMPHASIZE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = ColorManager.getInstance().getColor(ColorManager.GREY);
        }
    };
    public static final StyledString.Styler NULL_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };
    public static final CompletionFactory DEFAULT = new CompletionFactory();
    public static final ICompletionProposalSorter SORTER = new ICompletionProposalSorter(){

        public int compare(ICompletionProposal p1, ICompletionProposal p2) {
            if (p1 instanceof ScoreableProposal && p2 instanceof ScoreableProposal) {
                double s2;
                double s1 = ((ScoreableProposal)p1).getScore();
                if (s1 == (s2 = ((ScoreableProposal)p2).getScore())) {
                    String name1 = ((ScoreableProposal)p1).getDisplayString();
                    String name2 = ((ScoreableProposal)p2).getDisplayString();
                    return name1.compareTo(name2);
                }
                return Double.compare(s2, s1);
            }
            return 0;
        }
    };

    public static StyledString.Styler compose(final StyledString.Styler s1, final StyledString.Styler s2) {
        if (s1 == NULL_STYLER) {
            return s2;
        }
        if (s2 == NULL_STYLER) {
            return s1;
        }
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                s1.applyStyles(textStyle);
                s2.applyStyles(textStyle);
            }
        };
    }

    public ScoreableProposal simpleProposal(String name, String pattern, int sortingOrder, ProposalApplier applier, HoverInfo info) {
        return this.simpleProposal(name, pattern, -(1.0 + (double)sortingOrder), applier, info);
    }

    public ScoreableProposal simpleProposal(String name, String pattern, double score, ProposalApplier applier, HoverInfo info) {
        return new SimpleProposal(name, pattern, score, applier, info);
    }

    public ScoreableProposal simpleProposal(String name, String pattern, String label, double score, ProposalApplier applier, HoverInfo info) {
        return new SimpleProposal(name, pattern, label, score, applier, info);
    }

    public ScoreableProposal beanProperty(IDocument doc, final String contextProperty, final YType contextType, final String pattern, final YTypedProperty p, final double score, ProposalApplier applier, final YTypeUtil typeUtil) {
        return new AbstractPropertyProposal(doc, applier){

            @Override
            public double getBaseScore() {
                return score;
            }

            @Override
            protected String niceTypeName(YType type) {
                return typeUtil.niceTypeName(type);
            }

            @Override
            protected YType getType() {
                return p.getType();
            }

            @Override
            protected String getHighlightPattern() {
                return pattern;
            }

            @Override
            protected String getBaseDisplayString() {
                return p.getName();
            }

            @Override
            public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
                return new YPropertyHoverInfo(contextProperty, contextType, p);
            }
        };
    }

    public ScoreableProposal valueProposal(String value, String pattern, YType yType, double score, ProposalApplier applier, HoverInfo info) {
        return this.simpleProposal(value, pattern, score, applier, info);
    }

    public ScoreableProposal valueProposal(String value, String pattern, String label, YType yType, double score, ProposalApplier applier, HoverInfo info) {
        return this.simpleProposal(value, pattern, label, score, applier, info);
    }

    public ScoreableProposal valueProposal(String value, String pattern, YType type, int order, ProposalApplier applier, HoverInfo info) {
        return this.valueProposal(value, pattern, type, -(1.0 + (double)order), applier, info);
    }

    public static abstract class ScoreableProposal
    implements ICompletionProposal,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    ICompletionProposalExtension5,
    ICompletionProposalExtension6 {
        private static final double DEEMP_VALUE = 100000.0;
        private double deemphasizedBy = 0.0;

        public abstract double getBaseScore();

        public final double getScore() {
            return this.getBaseScore() - this.deemphasizedBy;
        }

        public ScoreableProposal deemphasize() {
            this.deemphasizedBy += 100000.0;
            return this;
        }

        public boolean isDeemphasized() {
            return this.deemphasizedBy > 0.0;
        }

        public boolean isAutoInsertable() {
            return !this.isDeemphasized();
        }

        public StyledString getStyledDisplayString() {
            StyledString result = new StyledString();
            this.highlightPattern(this.getHighlightPattern(), this.getBaseDisplayString(), result);
            return result;
        }

        private void highlightPattern(String pattern, String data, StyledString result) {
            StyledString.Styler plainStyle;
            StyledString.Styler highlightStyle = HIGHLIGHT;
            StyledString.Styler styler = plainStyle = this.isDeemphasized() ? DEEMPHASIZE : NULL_STYLER;
            if (this.isDeprecated()) {
                highlightStyle = CompletionFactory.compose(highlightStyle, DEPRECATE);
                plainStyle = CompletionFactory.compose(plainStyle, DEPRECATE);
            }
            if (StringUtils.hasText((String)pattern)) {
                int dataPos = 0;
                int dataLen = data.length();
                int patternPos = 0;
                int patternLen = pattern.length();
                while (dataPos < dataLen && patternPos < patternLen) {
                    char pChar;
                    int highlightPos;
                    if (dataPos < (highlightPos = data.indexOf(pChar = pattern.charAt(patternPos++), dataPos))) {
                        result.append(data.substring(dataPos, highlightPos), plainStyle);
                    }
                    result.append(data.charAt(highlightPos), highlightStyle);
                    dataPos = highlightPos + 1;
                }
                if (dataPos < dataLen) {
                    result.append(data.substring(dataPos), plainStyle);
                }
            } else {
                result.append(data, plainStyle);
            }
        }

        protected abstract boolean isDeprecated();

        protected abstract String getHighlightPattern();

        protected abstract String getBaseDisplayString();

        public IInformationControlCreator getInformationControlCreator() {
            return new HoverInformationControlCreator("F2 for focus");
        }

        public String getAdditionalProposalInfo() {
            HoverInfo hoverInfo = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
            if (hoverInfo != null) {
                return hoverInfo.getHtml();
            }
            return null;
        }

        public abstract HoverInfo getAdditionalProposalInfo(IProgressMonitor var1);

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return completionOffset;
        }
    }

    private static class SimpleProposal
    extends ScoreableProposal {
        private String value;
        private String label;
        private ProposalApplier applier;
        private double score;
        private String pattern;
        private HoverInfo hoverInfo;

        public SimpleProposal(String value, String pattern, double score, ProposalApplier applier, HoverInfo info) {
            this(value, pattern, value, score, applier, info);
        }

        public SimpleProposal(String value, String pattern, String label, double score, ProposalApplier applier, HoverInfo info) {
            this.score = score;
            this.value = value;
            this.applier = applier;
            this.pattern = pattern;
            this.hoverInfo = info;
            this.label = label;
        }

        public void apply(IDocument doc) {
            try {
                this.applier.apply(doc);
            }
            catch (Exception e) {
                EditorSupportActivator.log(e);
            }
        }

        public Point getSelection(IDocument doc) {
            try {
                return this.applier.getSelection(doc);
            }
            catch (Exception e) {
                EditorSupportActivator.log(e);
                return null;
            }
        }

        @Override
        public HoverInfo getAdditionalProposalInfo(IProgressMonitor monitor) {
            return this.hoverInfo;
        }

        public String getDisplayString() {
            return this.label.toString();
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        @Override
        public double getBaseScore() {
            return this.score;
        }

        @Override
        protected boolean isDeprecated() {
            return false;
        }

        @Override
        protected String getHighlightPattern() {
            return this.pattern;
        }

        @Override
        protected String getBaseDisplayString() {
            return this.label.toString();
        }
    }
}

