/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.hover;

import java.io.InputStream;
import javax.inject.Provider;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springsource.ide.eclipse.commons.frameworks.core.util.IOUtil;

public class DescriptionProviders {
    public static final Provider<HtmlSnippet> NO_DESCRIPTION = DescriptionProviders.snippet(HtmlSnippet.italic(HtmlSnippet.text("no description")));

    public static Provider<HtmlSnippet> snippet(final HtmlSnippet snippet) {
        return new Provider<HtmlSnippet>(){

            public String toString() {
                return snippet.toString();
            }

            public HtmlSnippet get() {
                return snippet;
            }
        };
    }

    public static Provider<HtmlSnippet> fromClasspath(final Class<?> klass, final String resourcePath) {
        return new Provider<HtmlSnippet>(){

            public String toString() {
                return "HtmlSnippetFromClassPth(class=" + klass.getSimpleName() + ", " + resourcePath + ")";
            }

            public HtmlSnippet get() {
                try {
                    InputStream stream = klass.getResourceAsStream(resourcePath);
                    if (stream != null) {
                        return HtmlSnippet.raw(IOUtil.toString((InputStream)stream));
                    }
                }
                catch (Exception e) {
                    EditorSupportActivator.log(e);
                }
                return (HtmlSnippet)NO_DESCRIPTION.get();
            }
        };
    }
}

