/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.hover;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;
import org.springframework.ide.eclipse.editor.support.util.HtmlUtil;

public abstract class HoverInfo
extends BrowserInformationControlInput {
    private static final String ACTION_HOST = "action";
    private Map<String, Runnable> actions = null;
    private String html;

    public HoverInfo() {
        super(null);
    }

    public Object getInputElement() {
        return this;
    }

    public String getInputName() {
        return "";
    }

    public final String getHtml() {
        if (this.html == null) {
            this.html = this.renderAsHtml();
        }
        return this.html;
    }

    protected abstract String renderAsHtml();

    public List<IJavaElement> getJavaElements() {
        return ImmutableList.of();
    }

    public static HoverInfo withText(final String plainText) {
        if (plainText != null) {
            return new HoverInfo(){

                @Override
                public String renderAsHtml() {
                    return HtmlUtil.text2html(plainText);
                }
            };
        }
        return null;
    }

    public boolean handleActionLink(String link) {
        String actionId = this.getActionLinkTarget(link);
        if (actionId != null) {
            Runnable action = this.getAction(actionId);
            if (action != null) {
                action.run();
            }
            return true;
        }
        return false;
    }

    private Runnable getAction(String actionId) {
        if (this.actions != null) {
            return this.actions.get(actionId);
        }
        return null;
    }

    public void actionLink(HtmlBuffer html, String displayString, Runnable runnable) {
        String actionId = this.registerAction(runnable);
        html.raw("<a href=\"http://action/");
        html.url(actionId);
        html.raw("\">");
        html.text(displayString);
        html.raw("</a>");
    }

    private synchronized String registerAction(Runnable runnable) {
        if (this.actions == null) {
            this.actions = new HashMap<String, Runnable>();
        }
        String actionId = "" + this.actions.size();
        this.actions.put(actionId, runnable);
        return actionId;
    }

    private String getActionLinkTarget(String location) {
        try {
            URI uri;
            if (location != null && ACTION_HOST.equals((uri = new URI(location)).getHost())) {
                String path = URLDecoder.decode(uri.getPath(), "utf8");
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return path;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

