/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.hover;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.hover.HoverInformationControlCreator;
import org.springframework.ide.eclipse.editor.support.util.HtmlUtil;

public class HoverInfoTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private HoverInfoProvider _hovers;
    private ITextHover delegate;

    public HoverInfoTextHover(ISourceViewer sourceViewer, HoverInfoProvider hoverInfoProvider, ITextHover delegate) {
        this._hovers = hoverInfoProvider;
        this.delegate = delegate;
    }

    public IRegion getHoverRegion(ITextViewer tv, int offset) {
        IRegion r;
        if (this.delegate != null && (r = this.delegate.getHoverRegion(tv, offset)) != null) {
            return r;
        }
        return this.hovers_getHoverRegion(tv.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer tv, IRegion r) {
        String s = this.delegate.getHoverInfo(tv, r);
        if (s != null) {
            return HtmlUtil.text2html(s);
        }
        return this.hovers_getHoverInfo(tv.getDocument(), r).getHtml();
    }

    public Object getHoverInfo2(ITextViewer tv, IRegion r) {
        String it;
        if (this.delegate instanceof ITextHoverExtension2) {
            Object it2 = ((ITextHoverExtension2)this.delegate).getHoverInfo2(tv, r);
            if (it2 != null) {
                if (it2 instanceof String) {
                    return HtmlUtil.text2html((String)it2);
                }
                return it2;
            }
        } else if (this.delegate instanceof ITextHover && (it = this.delegate.getHoverInfo(tv, r)) != null) {
            return HtmlUtil.text2html(it);
        }
        return this.hovers_getHoverInfo(tv.getDocument(), r);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new HoverInformationControlCreator(EditorsUI.getTooltipAffordanceString());
    }

    private IRegion hovers_getHoverRegion(IDocument document, int offset) {
        IRegion r = this._hovers.getHoverRegion(document, offset);
        return r;
    }

    private HoverInfo hovers_getHoverInfo(IDocument document, IRegion r) {
        HoverInfo result = this._hovers.getHoverInfo(document, r);
        return result;
    }
}

