/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.hover;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInformationControl;

public class HoverInformationControlCreator
implements IInformationControlCreator {
    private String statusText;
    private boolean enriched;

    public HoverInformationControlCreator(String statusText) {
        this(false, statusText);
    }

    public HoverInformationControlCreator(boolean enriched, String statusText) {
        this.enriched = enriched;
        this.statusText = statusText;
    }

    public IInformationControl createInformationControl(Shell parent) {
        if (BrowserInformationControl.isAvailable((Composite)parent)) {
            if (!this.enriched) {
                return new HoverInformationControl(parent, "org.eclipse.jdt.ui.javadocfont", this.statusText){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return new HoverInformationControlCreator(true, null);
                    }
                };
            }
            ToolBarManager toolbar = new ToolBarManager(0x800000);
            HoverInformationControl control = new HoverInformationControl(parent, "org.eclipse.jdt.ui.javadocfont", toolbar){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return new HoverInformationControlCreator(true, null);
                }
            };
            this.fillToolbar(toolbar, control);
            toolbar.update(true);
            return control;
        }
        return new DefaultInformationControl(parent, true);
    }

    private void fillToolbar(ToolBarManager tbm, BrowserInformationControl infoControl) {
        tbm.add((IAction)new OpenDeclarationAction(infoControl));
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText("Open Declaration");
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"goto_input.gif");
        }

        public void run() {
            try {
                List<IJavaElement> elements;
                HoverInfo infoInput;
                BrowserInformationControlInput input = this.fInfoControl.getInput();
                if (input instanceof HoverInfo && (infoInput = (HoverInfo)input) != null && !(elements = infoInput.getJavaElements()).isEmpty()) {
                    IJavaElement je = elements.get(0);
                    this.fInfoControl.notifyDelayedInputChange(null);
                    this.fInfoControl.dispose();
                    JavaUI.openInEditor((IJavaElement)je);
                }
            }
            catch (Exception e) {
                EditorSupportActivator.log(e);
            }
        }
    }
}

