/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.hover;

import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;
import org.springframework.util.StringUtils;

public class YPropertyHoverInfo
extends HoverInfo {
    private String contextProperty;
    private YTypedProperty prop;

    public YPropertyHoverInfo(String contextProperty, YType contextType, YTypedProperty prop) {
        this.contextProperty = contextProperty;
        this.prop = prop;
    }

    private String getName() {
        return this.prop.getName();
    }

    private YType getType() {
        return this.prop.getType();
    }

    @Override
    protected String renderAsHtml() {
        HtmlSnippet description;
        HtmlBuffer html = new HtmlBuffer();
        if (StringUtils.hasText((String)this.contextProperty)) {
            html.text(this.contextProperty);
            html.text(".");
        }
        html.raw("<b>");
        html.text(this.getName());
        html.raw("</b>");
        html.raw("<br>");
        YType type = this.getType();
        if (type != null) {
            this.actionLink(html, type.toString(), null);
        }
        if ((description = this.getDescription()) != null) {
            html.raw("<br><br>");
            html.snippet(description);
        }
        return html.toString();
    }

    protected HtmlSnippet getDescription() {
        return this.prop.getDescription();
    }
}

