/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.reconcile;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;

public class DefaultQuickfixContext
implements QuickfixContext {
    private final String PLUGIN_ID;
    private IPreferenceStore workspacePreferences;
    private ISourceViewer sourceViever;
    private UserInteractions ui;

    public DefaultQuickfixContext(String hostPluginId, IPreferenceStore workspacePreferences, ISourceViewer sourceViewer, UserInteractions ui) {
        this.PLUGIN_ID = hostPluginId;
        this.workspacePreferences = workspacePreferences;
        this.sourceViever = sourceViewer;
        this.ui = ui;
    }

    public IPreferenceStore getPreferences() {
        return this.workspacePreferences;
    }

    @Override
    public IProject getProject() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            return DocumentUtil.getProject(doc);
        }
        return null;
    }

    @Override
    public IJavaProject getJavaProject() {
        try {
            IProject p = this.getProject();
            if (p != null && p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)p);
            }
        }
        catch (Exception e) {
            EditorSupportActivator.log(e);
        }
        return null;
    }

    @Override
    public UserInteractions getUI() {
        return this.ui;
    }

    @Override
    public IPreferenceStore getWorkspacePreferences() {
        return this.workspacePreferences;
    }

    @Override
    public IPreferenceStore getProjectPreferences() {
        IProject project = this.getProject();
        if (project != null) {
            return new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), this.PLUGIN_ID);
        }
        return null;
    }

    @Override
    public IDocument getDocument() {
        return this.sourceViever.getDocument();
    }
}

