/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.reconcile;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;

public class ReconcileProblemAnnotation
extends Annotation
implements IQuickFixableAnnotation {
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.jdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.jdt.ui.warning";
    public static final Set<String> TYPES = new HashSet<String>();
    private ReconcileProblem fProblem;

    static {
        TYPES.add(ERROR_ANNOTATION_TYPE);
        TYPES.add(WARNING_ANNOTATION_TYPE);
    }

    public static String getAnnotationType(ProblemSeverity severity) {
        switch (severity) {
            case ERROR: {
                return ERROR_ANNOTATION_TYPE;
            }
            case WARNING: {
                return WARNING_ANNOTATION_TYPE;
            }
            case IGNORE: {
                return null;
            }
        }
        throw new IllegalStateException("Bug: Missing switch case!");
    }

    public ReconcileProblemAnnotation(String annotationType, ReconcileProblem problem) {
        super(annotationType, false, problem.getMessage());
        this.fProblem = problem;
    }

    public boolean isQuickFixable() {
        return true;
    }

    public boolean isQuickFixableStateSet() {
        return true;
    }

    public void setQuickFixable(boolean state) {
    }

    public ReconcileProblem getSpringPropertyProblem() {
        return this.fProblem;
    }
}

