/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.reconcile;

import java.util.Iterator;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.springframework.ide.eclipse.editor.support.hover.HoverInformationControlCreator;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemAnnotation;
import org.springframework.ide.eclipse.editor.support.reconcile.SpringPropertyProblemHoverInfo;

public class ReconcileProblemAnnotationHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private ISourceViewer sourceViewer;
    private QuickfixContext context;

    public ReconcileProblemAnnotationHover(ISourceViewer sourceViewer, QuickfixContext context) {
        this.sourceViewer = sourceViewer;
        this.context = context;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model = this.sourceViewer.getAnnotationModel();
        ReconcileProblemAnnotation annot = this.getAnnotationAt(model, hoverRegion.getOffset());
        if (annot != null) {
            return annot.getText();
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Position pos;
        IAnnotationModel model = this.sourceViewer.getAnnotationModel();
        ReconcileProblemAnnotation annot = this.getAnnotationAt(model, offset);
        if (annot != null && (pos = model.getPosition((Annotation)annot)) != null) {
            return new Region(pos.getOffset(), pos.getLength());
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model = this.sourceViewer.getAnnotationModel();
        ReconcileProblemAnnotation annot = this.getAnnotationAt(model, hoverRegion.getOffset());
        if (annot != null) {
            return new SpringPropertyProblemHoverInfo(annot.getSpringPropertyProblem(), this.context);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new HoverInformationControlCreator(false, "F2 for focus");
    }

    private ReconcileProblemAnnotation getAnnotationAt(IAnnotationModel model, int offset) {
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            ReconcileProblemAnnotation found = null;
            Position foundPos = null;
            while (iter.hasNext()) {
                ReconcileProblemAnnotation annotation;
                Position pos;
                Object _annotation = iter.next();
                if (!(_annotation instanceof ReconcileProblemAnnotation) || !this.isAtPosition(offset, pos = model.getPosition((Annotation)(annotation = (ReconcileProblemAnnotation)((Object)_annotation)))) || foundPos != null && pos.length >= foundPos.length) continue;
                found = annotation;
                foundPos = pos;
            }
            return found;
        }
        return null;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }
}

