/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.reconcile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.springframework.ide.eclipse.editor.support.reconcile.DefaultSeverityProvider;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemAnnotation;
import org.springframework.ide.eclipse.editor.support.reconcile.SeverityProvider;

public class ReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final SeverityProvider DEFAULT_SEVERITY_PROVIDER = new DefaultSeverityProvider();
    private ISourceViewer fViewer;
    private IReconcileEngine fEngine;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private IProblemCollector fProblemCollector;

    public ReconcileStrategy(ISourceViewer viewer, IReconcileEngine engine) {
        this.fViewer = viewer;
        this.fEngine = engine;
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        try {
            IRegion startLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset());
            IRegion endLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset() + Math.max(0, subRegion.getLength() - 1));
            subRegion = startLineInfo.getOffset() == endLineInfo.getOffset() ? startLineInfo : new Region(startLineInfo.getOffset(), endLineInfo.getOffset() + Math.max(0, endLineInfo.getLength() - 1) - startLineInfo.getOffset());
        }
        catch (BadLocationException badLocationException) {
            subRegion = new Region(0, this.fDocument.getLength());
        }
        this.reconcile((IRegion)subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.getAnnotationModel() == null || this.fProblemCollector == null) {
            return;
        }
        this.fEngine.reconcile(this.fDocument, this.fProblemCollector, this.fProgressMonitor);
    }

    protected IAnnotationModel getAnnotationModel() {
        return this.fViewer.getAnnotationModel();
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.fProblemCollector = this.createProblemCollector();
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected SeverityAwareProblemCollector createProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new SeverityAwareProblemCollector(model);
    }

    protected SeverityProvider getSeverities() {
        return DEFAULT_SEVERITY_PROVIDER;
    }

    private class SeverityAwareProblemCollector
    implements IProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map<Annotation, Position> fAddAnnotations;
        private Object fLockObject;

        public SeverityAwareProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        @Override
        public void accept(ReconcileProblem problem) {
            ProblemSeverity severity = ReconcileStrategy.this.getSeverities().getSeverity(problem);
            String annotationType = ReconcileProblemAnnotation.getAnnotationType(severity);
            if (annotationType != null) {
                this.fAddAnnotations.put(new ReconcileProblemAnnotation(annotationType, problem), new Position(problem.getOffset(), problem.getLength()));
            }
        }

        @Override
        public void beginCollecting() {
            ReconcileStrategy.this.getSeverities().startReconciling();
            this.fAddAnnotations = new HashMap<Annotation, Position>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endCollecting() {
            ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
            Object object = this.fLockObject;
            synchronized (object) {
                Iterator<Annotation> iter = this.fAnnotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!ReconcileProblemAnnotation.TYPES.contains(annotation.getType())) continue;
                    toRemove.add(annotation);
                }
                Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
                if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
                } else {
                    int i = 0;
                    while (i < annotationsToRemove.length) {
                        this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                        ++i;
                    }
                    for (Annotation annotation : this.fAddAnnotations.keySet()) {
                        this.fAnnotationModel.addAnnotation(annotation, this.fAddAnnotations.get(annotation));
                    }
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

