/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.reconcile;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.reconcile.FixableProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;

public class SpringPropertyProblemHoverInfo
extends HoverInfo {
    private ReconcileProblem problem;
    private QuickfixContext context;

    public SpringPropertyProblemHoverInfo(ReconcileProblem problem, QuickfixContext context) {
        this.problem = problem;
        this.context = context;
    }

    @Override
    protected String renderAsHtml() {
        HtmlBuffer html = new HtmlBuffer();
        html.text(this.problem.getMessage());
        this.renderQuickfixes(html, this.getQuickfixes(this.problem));
        return html.toString();
    }

    private List<ICompletionProposal> getQuickfixes(ReconcileProblem problem) {
        if (problem instanceof FixableProblem) {
            return ((FixableProblem)((Object)problem)).getQuickfixes(this.context);
        }
        return ImmutableList.of();
    }

    private void renderQuickfixes(HtmlBuffer html, List<ICompletionProposal> quickfixes) {
        if (!quickfixes.isEmpty()) {
            html.hline();
            if (quickfixes.size() == 1) {
                html.p("1 quickfix available:");
            } else {
                html.text(String.valueOf(quickfixes.size()) + " quickfixes available:");
            }
            html.raw("<ul>");
            for (ICompletionProposal fix : quickfixes) {
                html.raw("<li>");
                this.actionLink(html, fix.getDisplayString(), this.applyQuickfix(fix));
            }
            html.raw("</ul>");
            html.p("");
            html.p("");
            html.p("");
            html.p("");
        }
    }

    private Runnable applyQuickfix(final ICompletionProposal fix) {
        return new Runnable(){

            @Override
            public void run() {
                fix.apply(null);
            }
        };
    }

    public String toString() {
        return "SpringPropertyProblemHoverInfo(" + this.problem.getMessage() + ")";
    }
}

