/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;

public class DefaultUserInteractions
implements UserInteractions {
    private Shell shell;

    public DefaultUserInteractions(Shell shell) {
        this.shell = shell;
    }

    @Override
    public IContainer chooseOneSourceFolder(String title, String message, IContainer[] options, IContainer preferred) {
        int code;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContainer) {
                    IContainer c = (IContainer)element;
                    return c.getFullPath().toString();
                }
                return element.toString();
            }
        });
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])options);
        dialog.setBlockOnOpen(true);
        dialog.setMultipleSelection(false);
        if (preferred != null) {
            dialog.setInitialSelections(new Object[]{preferred});
        }
        if ((code = dialog.open()) == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    @Override
    public void error(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

