/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;

public class DocumentRegion
implements CharSequence {
    final IDocument doc;
    final int start;
    final int end;

    public DocumentRegion(IDocument doc, IRegion r) {
        this(doc, r.getOffset(), r.getOffset() + r.getLength());
    }

    public DocumentRegion(IDocument doc, int start, int end) {
        this.doc = doc;
        this.start = this.limitRange(start, 0, doc.getLength());
        this.end = this.limitRange(end, start, doc.getLength());
    }

    private int limitRange(int offset, int min, int max) {
        if (offset < min) {
            return min;
        }
        if (offset > max) {
            return max;
        }
        return offset;
    }

    @Override
    public String toString() {
        return DocumentUtil.textBetween(this.doc, this.start, this.end);
    }

    public DocumentRegion trim() {
        return this.trimEnd().trimStart();
    }

    public DocumentRegion trimStart() {
        int howMany = 0;
        int len = this.length();
        while (howMany < len && Character.isWhitespace(this.charAt(howMany))) {
            ++howMany;
        }
        return this.subSequence(howMany, len);
    }

    public DocumentRegion trimEnd() {
        int howMany = 0;
        int len = this.length();
        int lastChar = len - 1;
        while (howMany < len && Character.isWhitespace(this.charAt(lastChar - howMany))) {
            ++howMany;
        }
        if (howMany > 0) {
            return this.subSequence(0, len - howMany);
        }
        return this;
    }

    @Override
    public char charAt(int offset) {
        if (offset < 0 || offset >= this.length()) {
            throw new IndexOutOfBoundsException("" + offset);
        }
        try {
            return this.doc.getChar(this.start + offset);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException("" + offset);
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public DocumentRegion subSequence(int start, int end) {
        int len = this.length();
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        Assert.isLegal((end <= len ? 1 : 0) != 0);
        if (start == 0 && end == len) {
            return this;
        }
        return new DocumentRegion(this.doc, this.start + start, this.start + end);
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    public DocumentRegion subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    public IRegion asRegion() {
        return new Region(this.start, this.end - this.start);
    }

    public ITypedRegion asTypedRegion(String type) {
        return new TypedRegion(this.start, this.length(), type);
    }

    public int indexOf(char ch, int fromIndex) {
        while (fromIndex < this.length()) {
            if (this.charAt(fromIndex) == ch) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public DocumentRegion[] split(char c) {
        int end;
        ArrayList<DocumentRegion> pieces = new ArrayList<DocumentRegion>();
        int start = 0;
        while ((end = this.indexOf(c, start)) >= 0) {
            pieces.add(this.subSequence(start, end));
            start = end + 1;
        }
        pieces.add(this.subSequence(start, this.length()));
        return pieces.toArray(new DocumentRegion[pieces.size()]);
    }

    public DocumentRegion[] split(Pattern delimiter) {
        ArrayList<DocumentRegion> pieces = new ArrayList<DocumentRegion>();
        int start = 0;
        Matcher matcher = delimiter.matcher(this);
        while (matcher.find(start)) {
            int end = matcher.start();
            pieces.add(this.subSequence(start, end));
            start = matcher.end();
        }
        pieces.add(this.subSequence(start, this.length()));
        return pieces.toArray(new DocumentRegion[pieces.size()]);
    }

    public DocumentRegion trimStart(Pattern pat) {
        Matcher matcher = (pat = Pattern.compile("^(" + pat.pattern() + ")")).matcher(this);
        if (matcher.find()) {
            return this.subSequence(matcher.end());
        }
        return this;
    }

    public DocumentRegion trimEnd(Pattern pat) {
        Matcher matcher = (pat = Pattern.compile("(" + pat.pattern() + ")$")).matcher(this);
        if (matcher.find()) {
            return this.subSequence(0, matcher.start());
        }
        return this;
    }

    public DocumentRegion textAfter(int len) {
        Assert.isLegal((len >= 0 ? 1 : 0) != 0);
        return new DocumentRegion(this.doc, this.end, this.end + len);
    }

    public DocumentRegion textBefore(int len) {
        Assert.isLegal((len >= 0 ? 1 : 0) != 0);
        return new DocumentRegion(this.doc, this.start - len, this.start);
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int toRelative(int offset) {
        return offset - this.start;
    }
}

