/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;

public class EnumValueParser
implements ValueParser {
    private String typeName;
    private Set<String> values;

    public EnumValueParser(String typeName, String ... values) {
        this(typeName, (Collection<String>)ImmutableSet.copyOf((Object[])values));
    }

    public EnumValueParser(String typeName, Collection<String> values) {
        this.typeName = typeName;
        this.values = ImmutableSet.copyOf(values);
    }

    @Override
    public Object parse(String str) {
        if (this.values.contains(str)) {
            return str;
        }
        throw new IllegalArgumentException("'" + str + "' is not valid for Enum '" + this.typeName + "'");
    }
}

