/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;

public class HtmlBuffer {
    private StringBuffer buffer = new StringBuffer();
    private boolean epilogAdded = false;
    private static String fgCSSStyles;

    public void text(String text) {
        this.raw(HTMLPrinter.convertToHTMLContent((String)text));
    }

    public void raw(String rawText) {
        if (this.epilogAdded) {
            throw new IllegalStateException("Can not append more text after epilog was added");
        }
        this.buffer.append(rawText);
    }

    public void url(String string) {
        try {
            this.raw(URLEncoder.encode(string, "utf8"));
        }
        catch (UnsupportedEncodingException e) {
            EditorSupportActivator.log(e);
        }
    }

    public String toString() {
        if (!this.epilogAdded && this.buffer.length() > 0) {
            this.epilogAdded = true;
            HTMLPrinter.insertPageProlog((StringBuffer)this.buffer, (int)0, (String)HtmlBuffer.getCSSStyles());
            HTMLPrinter.addPageEpilog((StringBuffer)this.buffer);
        }
        return this.buffer.toString();
    }

    public static String getCSSStyles() {
        String css;
        block17: {
            Bundle bundle;
            URL url;
            if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)JavaPlugin.getPluginId())).getEntry("/JavadocHoverStyleSheet.css")) != null) {
                BufferedReader reader = null;
                try {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        StringBuffer buffer = new StringBuffer(200);
                        String line = reader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            buffer.append('\n');
                            line = reader.readLine();
                        }
                        fgCSSStyles = buffer.toString();
                    }
                    catch (IOException ex) {
                        JavaPlugin.log((Throwable)ex);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    public void hline() {
        this.raw("<hr>");
    }

    public void p(String string) {
        this.raw("<p>");
        this.text(string);
        this.raw("</p>");
    }

    public void snippet(HtmlSnippet snippet) {
        snippet.render(this);
    }

    public void bold(String string) {
        this.raw("<b>");
        this.text(string);
        this.raw("</b>");
    }
}

