/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;

public abstract class HtmlSnippet {
    public abstract void render(HtmlBuffer var1);

    public String toHtml() {
        HtmlBuffer buf = new HtmlBuffer();
        this.render(buf);
        return buf.toString();
    }

    public static HtmlSnippet text(final String text) {
        return new HtmlSnippet(){

            @Override
            public void render(HtmlBuffer html) {
                html.text(text);
            }
        };
    }

    public static HtmlSnippet raw(final String rawHtml) {
        return new HtmlSnippet(){

            @Override
            public void render(HtmlBuffer html) {
                html.raw(rawHtml);
            }
        };
    }

    public static HtmlSnippet italic(String text) {
        return HtmlSnippet.italic(HtmlSnippet.text(text));
    }

    public static HtmlSnippet italic(HtmlSnippet wrappee) {
        return new HtmlSnippet(){

            @Override
            public void render(HtmlBuffer html) {
                html.raw("<i>");
                HtmlSnippet.this.render(html);
                html.raw("</i>");
            }
        };
    }
}

