/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");

    public static boolean hasText(String name) {
        return name != null && !name.trim().equals("");
    }

    public static String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static String trimEnd(String s) {
        if (s != null) {
            return s.replaceAll("\\s+\\z", "");
        }
        return null;
    }

    public static int commonPrefixLength(CharSequence s, CharSequence t) {
        int shortestStringLen = Math.min(s.length(), t.length());
        int i = 0;
        while (i < shortestStringLen) {
            if (s.charAt(i) != t.charAt(i)) {
                return i;
            }
            ++i;
        }
        return shortestStringLen;
    }

    public static String commonPrefix(CharSequence s, CharSequence t) {
        int len = StringUtil.commonPrefixLength(s, t);
        if (len > 0) {
            return s.subSequence(0, len).toString();
        }
        return "";
    }

    public static String camelCaseToHyphens(String value) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(value);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, String.valueOf(matcher.group(1)) + '-' + matcher.group(2).toLowerCase());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] array) {
        return StringUtil.collectionToCommaDelimitedString(Arrays.asList(array));
    }

    public static String collectionToCommaDelimitedString(Collection<?> items) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Object item : items) {
            if (!first) {
                buf.append(",");
            }
            buf.append(item);
            first = false;
        }
        return buf.toString();
    }

    public static String upperCaseToHyphens(String v) {
        if (v != null) {
            return v.toLowerCase().replace('_', '-');
        }
        return null;
    }

    public static String hyphensToUpperCase(String v) {
        if (v != null) {
            return v.toUpperCase().replace('-', '_');
        }
        return null;
    }

    public static String hyphensToCamelCase(String propName, boolean startWithUpperCase) {
        String[] parts = propName.split("-");
        if (startWithUpperCase) {
            parts[0] = StringUtil.upCaseFirstChar(parts[0]);
        }
        StringBuilder camelCased = new StringBuilder(parts[0]);
        int i = 1;
        while (i < parts.length) {
            camelCased.append(StringUtil.upCaseFirstChar(parts[i]));
            ++i;
        }
        return camelCased.toString();
    }

    public static String upCaseFirstChar(String string) {
        if (StringUtil.hasText(string)) {
            return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
        }
        return "";
    }

    public static String datestamp() {
        Date d = new Date();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        return f.format(d);
    }
}

