/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Provider;
import org.dadacoalition.yedit.editor.YEditSourceViewerConfiguration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.ForceableReconciler;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.ICompletionEngine;
import org.springframework.ide.eclipse.editor.support.completions.ProposalProcessor;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoTextHover;
import org.springframework.ide.eclipse.editor.support.reconcile.DefaultQuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemAnnotationHover;
import org.springframework.ide.eclipse.editor.support.util.DefaultUserInteractions;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.YamlCompletionEngine;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.editor.support.yaml.hover.YamlHoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractYamlSourceViewerConfiguration
extends YEditSourceViewerConfiguration {
    private static final Set<String> ANNOTIONS_SHOWN_IN_TEXT = new HashSet<String>();
    private static final Set<String> ANNOTIONS_SHOWN_IN_OVERVIEW_BAR;
    private Provider<Shell> shellProvider;
    private final String DIALOG_SETTINGS_KEY = ((Object)((Object)this)).getClass().getName();
    private final YamlASTProvider astProvider = new YamlASTProvider(new Yaml());
    private YamlCompletionEngine completionEngine;
    protected ForceableReconciler fReconciler;

    static {
        ANNOTIONS_SHOWN_IN_TEXT.add("org.eclipse.jdt.ui.warning");
        ANNOTIONS_SHOWN_IN_TEXT.add("org.eclipse.jdt.ui.error");
        ANNOTIONS_SHOWN_IN_OVERVIEW_BAR = ANNOTIONS_SHOWN_IN_TEXT;
    }

    public AbstractYamlSourceViewerConfiguration(Provider<Shell> shellProvider) {
        this.shellProvider = shellProvider;
    }

    protected final IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = this.getPluginDialogSettings();
        IDialogSettings existing = dialogSettings.getSection(this.DIALOG_SETTINGS_KEY);
        if (existing != null) {
            return existing;
        }
        IDialogSettings created = dialogSettings.addNewSection(this.DIALOG_SETTINGS_KEY);
        Point defaultPopupSize = this.getDefaultPopupSize();
        if (defaultPopupSize != null) {
            int suggestW = defaultPopupSize.x;
            int suggestH = defaultPopupSize.y;
            created.put("size.x", suggestW);
            created.put("size.y", suggestH);
        }
        return created;
    }

    protected Point getDefaultPopupSize() {
        return null;
    }

    protected abstract IDialogSettings getPluginDialogSettings();

    public final IContentAssistant getContentAssistant(ISourceViewer viewer) {
        IContentAssistant _a = super.getContentAssistant(viewer);
        if (_a instanceof ContentAssistant) {
            ContentAssistant a = (ContentAssistant)_a;
            a.setInformationControlCreator(this.getInformationControlCreator(viewer));
            a.enableColoredLabels(true);
            a.enablePrefixCompletion(false);
            a.enableAutoInsert(true);
            a.enableAutoActivation(true);
            a.setRestoreCompletionProposalSize(this.getDialogSettings());
            ProposalProcessor processor = new ProposalProcessor(this.getCompletionEngine());
            a.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            a.setSorter(CompletionFactory.SORTER);
        }
        return _a;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (contentType.equals("__dftl_partition_content_type") && 255 == stateMask) {
            ITextHover delegate = this.getTextAnnotationHover(sourceViewer);
            try {
                HoverInfoProvider hoverProvider = this.getHoverProvider();
                if (hoverProvider != null) {
                    return new HoverInfoTextHover(sourceViewer, this.getHoverProvider(), delegate);
                }
            }
            catch (Exception e) {
                EditorSupportActivator.log(e);
            }
            return delegate;
        }
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }

    public final ICompletionEngine getCompletionEngine() {
        if (this.completionEngine == null) {
            this.completionEngine = new YamlCompletionEngine(this.getStructureProvider(), this.getAssistContextProvider());
        }
        return this.completionEngine;
    }

    protected final HoverInfoProvider getHoverProvider() {
        return new YamlHoverInfoProvider(this.getAstProvider(), this.getStructureProvider(), this.getAssistContextProvider());
    }

    protected final YamlASTProvider getAstProvider() {
        return this.astProvider;
    }

    public final IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fReconciler == null) {
            this.fReconciler = this.createReconciler(sourceViewer);
        }
        return this.fReconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return ANNOTIONS_SHOWN_IN_OVERVIEW_BAR.contains(annotation.getType());
            }
        };
    }

    protected ITextHover getTextAnnotationHover(ISourceViewer sourceViewer) {
        return new ReconcileProblemAnnotationHover(sourceViewer, this.getQuickfixContext(sourceViewer));
    }

    protected Shell getShell() {
        return (Shell)this.shellProvider.get();
    }

    protected final QuickfixContext getQuickfixContext(ISourceViewer sourceViewer) {
        return new DefaultQuickfixContext(this.getPluginId(), this.getPreferencesStore(), sourceViewer, new DefaultUserInteractions(this.getShell()));
    }

    protected abstract String getPluginId();

    protected abstract IPreferenceStore getPreferencesStore();

    protected abstract YamlStructureProvider getStructureProvider();

    protected abstract YamlAssistContextProvider getAssistContextProvider();

    protected IReconcilingStrategy createReconcilerStrategy(ISourceViewer sourceViewer) {
        return null;
    }

    protected ForceableReconciler createReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy strategy = this.createReconcilerStrategy(sourceViewer);
        if (strategy != null) {
            ForceableReconciler reconciler = new ForceableReconciler(strategy);
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }
}

