/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.ICompletionEngine;
import org.springframework.ide.eclipse.editor.support.util.YamlIndentUtil;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;

public class YamlCompletionEngine
implements ICompletionEngine {
    private final YamlAssistContextProvider contextProvider;
    protected final YamlStructureProvider structureProvider;

    public YamlCompletionEngine(YamlStructureProvider structureProvider, YamlAssistContextProvider contextProvider) {
        Assert.isNotNull((Object)structureProvider);
        Assert.isNotNull((Object)contextProvider);
        this.structureProvider = structureProvider;
        this.contextProvider = contextProvider;
    }

    protected final YamlAssistContext getGlobalContext(YamlDocument doc) {
        return this.contextProvider.getGlobalAssistContext(doc);
    }

    protected CompletionFactory proposalFactory() {
        return CompletionFactory.DEFAULT;
    }

    @Override
    public Collection<ICompletionProposal> getCompletions(IDocument _doc, int offset) throws Exception {
        YamlDocument doc = new YamlDocument(_doc, this.structureProvider);
        if (!doc.isCommented(offset)) {
            YamlPath contextPath;
            YamlStructureParser.SRootNode root = doc.getStructure();
            YamlStructureParser.SNode current = root.find(offset);
            YamlAssistContext context = this.getContext(doc, offset, current, contextPath = this.getContextPath(doc, current, offset));
            if (context == null && this.isDubiousKey(current, offset)) {
                current = current.getParent();
                contextPath = contextPath.dropLast();
                context = this.getContext(doc, offset, current, contextPath);
            }
            if (context != null) {
                return context.getCompletions(doc, current, offset);
            }
        }
        return Collections.emptyList();
    }

    private boolean isDubiousKey(YamlStructureParser.SNode node, int offset) {
        if (node.getNodeType() == YamlStructureParser.SNodeType.KEY) {
            YamlStructureParser.SKeyNode key = (YamlStructureParser.SKeyNode)node;
            return key.getColonOffset() + 1 == offset;
        }
        return false;
    }

    protected YamlAssistContext getContext(YamlDocument doc, int offset, YamlStructureParser.SNode node, YamlPath contextPath) {
        try {
            return contextPath.traverse(this.getGlobalContext(doc));
        }
        catch (Exception e) {
            EditorSupportActivator.log(e);
            return null;
        }
    }

    protected YamlPath getContextPath(YamlDocument doc, YamlStructureParser.SNode node, int offset) throws Exception {
        if (node == null) {
            return YamlPath.EMPTY;
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.KEY) {
            YamlStructureParser.SKeyNode keyNode = (YamlStructureParser.SKeyNode)node;
            if (keyNode.isInValue(offset)) {
                return keyNode.getPath();
            }
            return keyNode.getParent().getPath();
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.RAW) {
            int cursorIndent = doc.getColumn(offset);
            int nodeIndent = node.getIndent();
            int currentIndent = YamlIndentUtil.minIndent(cursorIndent, nodeIndent);
            while (node.getIndent() == -1 || node.getIndent() >= currentIndent && node.getNodeType() != YamlStructureParser.SNodeType.DOC) {
                node = node.getParent();
            }
            return node.getPath();
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.SEQ) {
            YamlStructureParser.SSeqNode seqNode = (YamlStructureParser.SSeqNode)node;
            if (seqNode.isInValue(offset)) {
                return seqNode.getPath();
            }
            return seqNode.getParent().getPath();
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.DOC) {
            return node.getPath();
        }
        throw new IllegalStateException("Missing case");
    }
}

