/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;

public class YamlDocument {
    private IDocument doc;
    private YamlStructureProvider structureProvider;
    private YamlStructureParser.SRootNode structure;

    public YamlDocument(IDocument _doc, YamlStructureProvider structureProvider) {
        this.doc = _doc;
        this.structureProvider = structureProvider;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public YamlStructureParser.SRootNode getStructure() throws Exception {
        if (this.structure == null) {
            this.structure = this.structureProvider.getStructure(this);
        }
        return this.structure;
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        return this.doc.getLineOfOffset(offset);
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.doc.getLineInformation(line);
    }

    public int getLineOffset(int line) throws BadLocationException {
        return this.doc.getLineOffset(line);
    }

    public int getLineIndentation(int line) {
        IRegion r;
        try {
            r = this.getLineInformation(line);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int len = r.getLength();
        int startOfLine = r.getOffset();
        int leadingSpaces = 0;
        while (leadingSpaces < len) {
            char c = this.getChar(startOfLine + leadingSpaces);
            if (c == ' ') {
                ++leadingSpaces;
            } else {
                if (c == '#') {
                    return -1;
                }
                if (c != ' ') {
                    return leadingSpaces;
                }
            }
            ++leadingSpaces;
        }
        return -1;
    }

    public char getChar(int offset) {
        try {
            return this.doc.getChar(offset);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    public boolean isCommented(int offset) throws Exception {
        IRegion lineInfo = this.doc.getLineInformationOfOffset(offset);
        int startOfLine = lineInfo.getOffset();
        while (offset >= startOfLine) {
            char c = this.getChar(offset);
            if (c == '#') {
                return true;
            }
            --offset;
        }
        return false;
    }

    public String textBetween(int start, int end) {
        return DocumentUtil.textBetween(this.doc, start, end);
    }

    public int getColumn(int offset) throws Exception {
        IRegion r = this.doc.getLineInformationOfOffset(offset);
        return offset - r.getOffset();
    }

    public String getLineTextBefore(int offset) throws Exception {
        IRegion l = this.doc.getLineInformationOfOffset(offset);
        return this.textBetween(l.getOffset(), offset);
    }

    public String getLineTextAtOffset(int offset) throws Exception {
        IRegion l = this.doc.getLineInformationOfOffset(offset);
        return this.textBetween(l.getOffset(), l.getOffset() + l.getLength());
    }

    public int getStartOfLineAtOffset(int offset) throws Exception {
        return this.doc.getLineInformationOfOffset(offset).getOffset();
    }

    public String toString() {
        return "YamlDocument(>>>>\n" + this.getDocument().get() + "\n<<<<)";
    }
}

