/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.ast;

import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.SequenceNode;

public abstract class NodeRef<Parent> {
    private Parent parent;

    public NodeRef(Parent parent) {
        this.parent = parent;
    }

    public Parent getParent() {
        return this.parent;
    }

    public abstract Node get();

    public abstract void put(Node var1);

    public abstract String toString();

    public abstract Kind getKind();

    public static enum Kind {
        ROOT,
        SEQ,
        KEY,
        VAL;

    }

    public static class RootRef
    extends NodeRef<YamlFileAST> {
        private int index;

        public RootRef(YamlFileAST file, int index) {
            super(file);
            this.index = index;
        }

        @Override
        public Node get() {
            return ((YamlFileAST)this.getParent()).get(this.index);
        }

        @Override
        public void put(Node value) {
            ((YamlFileAST)this.getParent()).put(this.index, value);
        }

        @Override
        public String toString() {
            return "ROOT[" + this.index + "]";
        }

        @Override
        public Kind getKind() {
            return Kind.ROOT;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class SeqRef
    extends NodeRef<SequenceNode> {
        private int index;

        public SeqRef(SequenceNode seq, int index) {
            super(seq);
            this.index = index;
        }

        @Override
        public Node get() {
            return (Node)((SequenceNode)this.getParent()).getValue().get(this.index);
        }

        @Override
        public void put(Node value) {
            ((SequenceNode)this.getParent()).getValue().set(this.index, value);
        }

        @Override
        public String toString() {
            return "[" + this.index + "]";
        }

        @Override
        public Kind getKind() {
            return Kind.SEQ;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class TupleKeyRef
    extends TupleRef {
        public TupleKeyRef(MappingNode parent, int index) {
            super(parent, index);
        }

        @Override
        public Node get() {
            return this.getTuple().getKeyNode();
        }

        @Override
        public void put(Node newKey) {
            NodeTuple tuple = this.getTuple();
            this.putTuple(new NodeTuple(newKey, tuple.getValueNode()));
        }

        @Override
        public String toString() {
            return "@key[" + this.index + "]";
        }

        @Override
        public Kind getKind() {
            return Kind.KEY;
        }
    }

    public static abstract class TupleRef
    extends NodeRef<MappingNode> {
        protected int index;

        public TupleRef(MappingNode map, int index) {
            super(map);
            this.index = index;
        }

        public NodeTuple getTuple() {
            return (NodeTuple)((MappingNode)this.getParent()).getValue().get(this.index);
        }

        public void putTuple(NodeTuple value) {
            ((MappingNode)this.getParent()).getValue().set(this.index, value);
        }
    }

    public static class TupleValueRef
    extends TupleRef {
        public TupleValueRef(MappingNode parent, int index) {
            super(parent, index);
        }

        @Override
        public Node get() {
            return this.getTuple().getValueNode();
        }

        @Override
        public void put(Node newValue) {
            NodeTuple t = this.getTuple();
            this.putTuple(new NodeTuple(t.getKeyNode(), newValue));
        }

        @Override
        public String toString() {
            String keyString = NodeUtil.asScalar(this.getTuple().getKeyNode());
            if (keyString != null) {
                return "@val['" + keyString + "']";
            }
            return "@val[" + this.index + "]";
        }

        @Override
        public Kind getKind() {
            return Kind.VAL;
        }

        public Node getKey() {
            return this.getTuple().getKeyNode();
        }
    }
}

