/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.ast;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.yaml.snakeyaml.Yaml;

public class YamlASTProvider {
    private YamlFileAST cached = null;
    private IDocument cachedFor = null;
    private IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(final DocumentEvent event) {
            Job job = new Job("Clear YamlASTProvider Cache"){

                protected IStatus run(IProgressMonitor monitor) {
                    YamlASTProvider.this.changed(event.getDocument());
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setSystem(true);
            job.schedule();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };
    private Yaml yaml;

    public YamlASTProvider(Yaml yaml) {
        this.yaml = yaml;
    }

    private synchronized void changed(IDocument doc) {
        if (doc == this.cachedFor) {
            doc.removeDocumentListener(this.listener);
            this.cachedFor = null;
            this.cached = null;
        }
    }

    public synchronized YamlFileAST getAST(IDocument doc) {
        if (doc == this.cachedFor) {
            return this.cached;
        }
        if (this.cachedFor != null) {
            this.cachedFor.removeDocumentListener(this.listener);
        }
        doc.addDocumentListener(this.listener);
        this.cached = new YamlFileAST(this.yaml.composeAll((Reader)new StringReader(doc.get())));
        this.cachedFor = doc;
        return this.cached;
    }
}

