/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.completions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;

public abstract class AbstractPropertyProposal
extends CompletionFactory.ScoreableProposal
implements ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension6 {
    protected final IDocument fDoc;
    private final ProposalApplier proposalApplier;
    private boolean isDeprecated = false;

    public AbstractPropertyProposal(IDocument doc, ProposalApplier applier) {
        this.proposalApplier = applier;
        this.fDoc = doc;
    }

    public Point getSelection(IDocument document) {
        try {
            return this.proposalApplier.getSelection(document);
        }
        catch (Exception e) {
            EditorSupportActivator.log(e);
            return null;
        }
    }

    public String getDisplayString() {
        StyledString styledText = this.getStyledDisplayString();
        return styledText.getString();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public StyledString getStyledDisplayString() {
        StyledString result = new StyledString();
        result = result.append(super.getStyledDisplayString());
        YType type = this.getType();
        if (type != null) {
            String typeStr = this.niceTypeName(type);
            result.append(" : " + typeStr, StyledString.DECORATIONS_STYLER);
        }
        return result;
    }

    @Override
    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void deprecate() {
        if (!this.isDeprecated()) {
            this.deemphasize();
            this.deemphasize();
            this.isDeprecated = true;
        }
    }

    protected abstract YType getType();

    @Override
    protected abstract String getHighlightPattern();

    @Override
    protected abstract String getBaseDisplayString();

    protected abstract String niceTypeName(YType var1);

    public String toString() {
        return this.getBaseDisplayString();
    }

    public void apply(IDocument document) {
        try {
            this.proposalApplier.apply(document);
        }
        catch (Exception e) {
            EditorSupportActivator.log(e);
        }
    }
}

