/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.completions;

import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;
import org.springframework.ide.eclipse.editor.support.util.PrefixFinder;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlPathEdits;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;

public abstract class AbstractYamlAssistContext
implements YamlAssistContext {
    public final int documentSelector;
    public final YamlPath contextPath;
    private static PrefixFinder prefixfinder = new PrefixFinder(){

        @Override
        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c);
        }
    };

    public static void deleteQueryAndLine(YamlDocument doc, String query, int queryOffset, YamlPathEdits edits) throws Exception {
        edits.delete(queryOffset, query);
        String wholeLine = doc.getLineTextAtOffset(queryOffset);
        if (wholeLine.trim().equals(query.trim())) {
            edits.deleteLineBackwardAtOffset(queryOffset);
        }
    }

    protected final String getPrefix(YamlDocument doc, YamlStructureParser.SNode node, int offset) {
        YamlStructureParser.SKeyNode keyNode;
        if (node.getNodeType() == YamlStructureParser.SNodeType.KEY && (keyNode = (YamlStructureParser.SKeyNode)node).isInValue(offset)) {
            int valueStart = keyNode.getColonOffset() + 1;
            while (valueStart <= offset && Character.isWhitespace(doc.getChar(valueStart))) {
                ++valueStart;
            }
            if (offset >= valueStart) {
                return doc.textBetween(valueStart, offset);
            }
            return "";
        }
        return prefixfinder.getPrefix(doc.getDocument(), offset);
    }

    public AbstractYamlAssistContext(int documentSelector, YamlPath contextPath) {
        this.documentSelector = documentSelector;
        this.contextPath = contextPath;
    }

    protected YamlStructureParser.SNode getContextNode(YamlDocument file) throws Exception {
        return this.contextPath.traverse(this.getContextRoot(file));
    }

    protected YamlStructureParser.SDocNode getContextRoot(YamlDocument file) throws Exception {
        YamlStructureParser.SRootNode root = file.getStructure();
        return (YamlStructureParser.SDocNode)root.getChildren().get(this.documentSelector);
    }

    protected CompletionFactory completionFactory() {
        return CompletionFactory.DEFAULT;
    }

    @Override
    public HoverInfo getHoverInfo() {
        return null;
    }

    @Override
    public HoverInfo getValueHoverInfo(YamlDocument doc, DocumentRegion documentRegion) {
        return this.getHoverInfo();
    }
}

