/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.completions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.completions.DocumentEdits;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.YPropertyHoverInfo;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import org.springframework.ide.eclipse.editor.support.util.YamlIndentUtil;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.AbstractYamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.TopLevelAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlPathEdits;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YValueHint;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;

public class YTypeAssistContext
extends AbstractYamlAssistContext {
    private final YTypeUtil typeUtil;
    private final YType type;
    private final YamlAssistContext parent;

    public YTypeAssistContext(YTypeAssistContext parent, YamlPath contextPath, YType YType2, YTypeUtil typeUtil) {
        super(parent.documentSelector, contextPath);
        this.parent = parent;
        this.type = YType2;
        this.typeUtil = typeUtil;
    }

    public YTypeAssistContext(TopLevelAssistContext parent, int documentSelector, YType type, YTypeUtil typeUtil) {
        super(documentSelector, YamlPath.EMPTY);
        this.type = type;
        this.typeUtil = typeUtil;
        this.parent = parent;
    }

    @Override
    public Collection<ICompletionProposal> getCompletions(YamlDocument doc, YamlStructureParser.SNode node, int offset) throws Exception {
        String query = this.getPrefix(doc, node, offset);
        List<ICompletionProposal> valueCompletions = this.getValueCompletions(doc, offset, query);
        if (!valueCompletions.isEmpty()) {
            return valueCompletions;
        }
        return this.getKeyCompletions(doc, offset, query);
    }

    public List<ICompletionProposal> getKeyCompletions(YamlDocument doc, int offset, String query) throws Exception {
        int queryOffset = offset - query.length();
        List<YTypedProperty> properties = this.typeUtil.getProperties(this.type);
        if (CollectionUtil.hasElements(properties)) {
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(properties.size());
            YamlStructureParser.SNode contextNode = this.getContextNode(doc);
            Set<String> definedProps = this.getDefinedProperties(contextNode);
            for (YTypedProperty p : properties) {
                String name = p.getName();
                double score = FuzzyMatcher.matchScore(query, name);
                if (score == 0.0) continue;
                YamlPath relativePath = YamlPath.fromSimpleProperty(name);
                YamlPathEdits edits = new YamlPathEdits(doc);
                if (!definedProps.contains(name)) {
                    YType YType2 = p.getType();
                    edits.delete(queryOffset, query);
                    edits.createPathInPlace(contextNode, relativePath, queryOffset, this.appendTextFor(YType2));
                    proposals.add(this.completionFactory().beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, edits, this.typeUtil));
                    continue;
                }
                YTypeAssistContext.deleteQueryAndLine(doc, query, queryOffset, edits);
                edits.createPath((YamlStructureParser.SChildBearingNode)contextNode, relativePath, "");
                proposals.add(this.completionFactory().beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, edits, this.typeUtil).deemphasize());
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    protected String appendTextFor(YType type) {
        if (type == null) {
            return "\n" + YamlIndentUtil.INDENT_STR;
        }
        if (this.typeUtil.isMap(type)) {
            return "\n" + YamlIndentUtil.INDENT_STR;
        }
        if (this.typeUtil.isSequencable(type)) {
            return "\n- ";
        }
        if (this.typeUtil.isAtomic(type)) {
            return " ";
        }
        return "\n" + YamlIndentUtil.INDENT_STR;
    }

    private Set<String> getDefinedProperties(YamlStructureParser.SNode contextNode) {
        try {
            List<YamlStructureParser.SNode> children;
            if (contextNode instanceof YamlStructureParser.SChildBearingNode && CollectionUtil.hasElements(children = ((YamlStructureParser.SChildBearingNode)contextNode).getChildren())) {
                HashSet<String> keys = new HashSet<String>(children.size());
                for (YamlStructureParser.SNode c : children) {
                    if (!(c instanceof YamlStructureParser.SKeyNode)) continue;
                    keys.add(((YamlStructureParser.SKeyNode)c).getKey());
                }
                return keys;
            }
        }
        catch (Exception e) {
            EditorSupportActivator.log(e);
        }
        return Collections.emptySet();
    }

    private List<ICompletionProposal> getValueCompletions(YamlDocument doc, int offset, String query) {
        YValueHint[] values = this.typeUtil.getHintValues(this.type);
        if (values != null) {
            ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
            YValueHint[] yValueHintArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                YValueHint value = yValueHintArray[n2];
                double score = FuzzyMatcher.matchScore(query, value.getValue());
                if (score != 0.0 && !value.equals(query)) {
                    DocumentEdits edits = new DocumentEdits(doc.getDocument());
                    edits.delete(offset - query.length(), offset);
                    edits.insert(offset, value.getValue());
                    completions.add(this.completionFactory().valueProposal(value.getValue(), query, value.getLabel(), this.type, score, edits, null));
                }
                ++n2;
            }
            return completions;
        }
        return Collections.emptyList();
    }

    @Override
    public YamlAssistContext traverse(YamlPathSegment s) {
        if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
            if (this.typeUtil.isSequencable(this.type) || this.typeUtil.isMap(this.type)) {
                return this.contextWith(s, this.typeUtil.getDomainType(this.type));
            }
            String key = s.toPropString();
            Map<String, YTypedProperty> subproperties = this.typeUtil.getPropertiesMap(this.type);
            if (subproperties != null) {
                return this.contextWith(s, this.getType(subproperties.get(key)));
            }
        } else if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_INDEX && this.typeUtil.isSequencable(this.type)) {
            return this.contextWith(s, this.typeUtil.getDomainType(this.type));
        }
        return null;
    }

    private YType getType(YTypedProperty prop) {
        if (prop != null) {
            return prop.getType();
        }
        return null;
    }

    private YamlAssistContext contextWith(YamlPathSegment s, YType nextType) {
        if (nextType != null) {
            return new YTypeAssistContext(this, this.contextPath.append(s), nextType, this.typeUtil);
        }
        return null;
    }

    public String toString() {
        return "TypeContext(" + this.contextPath.toPropString() + "::" + this.type + ")";
    }

    @Override
    public HoverInfo getHoverInfo() {
        if (this.parent != null) {
            return this.parent.getHoverInfo(this.contextPath.getLastSegment());
        }
        return null;
    }

    public YType getType() {
        return this.type;
    }

    @Override
    public HoverInfo getHoverInfo(YamlPathSegment lastSegment) {
        switch (lastSegment.getType()) {
            case VAL_AT_KEY: 
            case KEY_AT_KEY: {
                YTypedProperty prop = this.getProperty(lastSegment.toPropString());
                if (prop == null) break;
                return new YPropertyHoverInfo(this.contextPath.toPropString(), this.getType(), prop);
            }
        }
        return null;
    }

    private YTypedProperty getProperty(String name) {
        return this.typeUtil.getPropertiesMap(this.getType()).get(name);
    }
}

