/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.completions;

public class YamlUtil {
    private static final String[] SPECIAL_START = new String[]{"!", "#", "&", "*", ">", "|", "?", "{", "}", "[", "]", ",", "\"", "'", "`", "@", "- ", "\t", " "};
    private static final String[] SPECIAL_END = new String[]{"\t", " "};
    private static final String[] SPECIAL_CONTENT = new String[]{": ", " #", "\n", "\r"};

    public static String stringEscape(String value) {
        if (YamlUtil.canInsertAsIs(value)) {
            return value;
        }
        return "'" + value.replace("'", "''") + "'";
    }

    private static boolean canInsertAsIs(String value) {
        String special;
        String[] stringArray = SPECIAL_START;
        int n = SPECIAL_START.length;
        int n2 = 0;
        while (n2 < n) {
            special = stringArray[n2];
            if (value.startsWith(special)) {
                return false;
            }
            ++n2;
        }
        stringArray = SPECIAL_END;
        n = SPECIAL_END.length;
        n2 = 0;
        while (n2 < n) {
            special = stringArray[n2];
            if (value.endsWith(special)) {
                return false;
            }
            ++n2;
        }
        stringArray = SPECIAL_CONTENT;
        n = SPECIAL_CONTENT.length;
        n2 = 0;
        while (n2 < n) {
            special = stringArray[n2];
            if (value.contains(special)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

