/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.hover;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfoProvider;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeRef;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class YamlHoverInfoProvider
implements HoverInfoProvider {
    private YamlASTProvider astProvider;
    private YamlAssistContextProvider assistContextProvider;
    private YamlStructureProvider structureProvider;

    public YamlHoverInfoProvider(YamlASTProvider astProvider, YamlStructureProvider structureProvider, YamlAssistContextProvider assistContextProvider) {
        Assert.isNotNull((Object)astProvider);
        Assert.isNotNull((Object)structureProvider);
        Assert.isNotNull((Object)assistContextProvider);
        this.astProvider = astProvider;
        this.structureProvider = structureProvider;
        this.assistContextProvider = assistContextProvider;
    }

    @Override
    public HoverInfo getHoverInfo(IDocument doc, IRegion r) {
        List<NodeRef<?>> astPath;
        YamlPath path;
        YamlDocument ymlDoc;
        YamlAssistContext assistContext;
        YamlFileAST ast = this.getAst(doc);
        if (ast != null && (assistContext = this.assistContextProvider.getGlobalAssistContext(ymlDoc = new YamlDocument(doc, this.structureProvider))) != null && (path = YamlPath.fromASTPath(astPath = ast.findPath(r.getOffset()))) != null) {
            YamlPath assistPath = path;
            if (assistPath.pointsAtKey()) {
                String key = path.getLastSegment().toPropString();
                assistPath = path.dropLast().append(YamlPathSegment.valueAt(key));
            }
            if ((assistContext = assistPath.traverse(assistContext)) != null) {
                if (path.pointsAtValue()) {
                    return assistContext.getValueHoverInfo(ymlDoc, new DocumentRegion(doc, r));
                }
                return assistContext.getHoverInfo();
            }
        }
        return null;
    }

    @Override
    public IRegion getHoverRegion(IDocument document, int offset) {
        Node n;
        YamlFileAST ast = this.getAst(document);
        if (ast != null && (n = ast.findNode(offset)) != null && n.getNodeId() == NodeId.scalar) {
            int start = n.getStartMark().getIndex();
            int end = n.getEndMark().getIndex();
            return new Region(start, end - start);
        }
        return null;
    }

    private YamlFileAST getAst(IDocument doc) {
        try {
            return this.astProvider.getAST(doc);
        }
        catch (ParserException | ScannerException throwable) {
            return null;
        }
    }
}

