/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeRef;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlNavigable;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;

public class YamlPath {
    public static final YamlPath EMPTY = new YamlPath();
    private final YamlPathSegment[] segments;

    public YamlPath(List<YamlPathSegment> segments) {
        this.segments = segments.toArray(new YamlPathSegment[segments.size()]);
    }

    public YamlPath() {
        this.segments = new YamlPathSegment[0];
    }

    public YamlPath(YamlPathSegment ... segments) {
        this.segments = segments;
    }

    public String toPropString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        YamlPathSegment[] yamlPathSegmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            YamlPathSegment s = yamlPathSegmentArray[n2];
            if (first) {
                buf.append(s.toPropString());
            } else {
                buf.append(s.toNavString());
            }
            first = false;
            ++n2;
        }
        return buf.toString();
    }

    public String toNavString() {
        StringBuilder buf = new StringBuilder();
        YamlPathSegment[] yamlPathSegmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            YamlPathSegment s = yamlPathSegmentArray[n2];
            buf.append(s.toNavString());
            ++n2;
        }
        return buf.toString();
    }

    public YamlPathSegment[] getSegments() {
        return this.segments;
    }

    public static YamlPath fromProperty(String propName) {
        ArrayList<YamlPathSegment> segments = new ArrayList<YamlPathSegment>();
        String[] stringArray = propName.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            segments.add(YamlPathSegment.valueAt(s));
            ++n2;
        }
        return new YamlPath(segments);
    }

    public static YamlPath fromSimpleProperty(String name) {
        return new YamlPath(YamlPathSegment.valueAt(name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("YamlPath(");
        boolean first = true;
        YamlPathSegment[] yamlPathSegmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            YamlPathSegment s = yamlPathSegmentArray[n2];
            if (!first) {
                buf.append(", ");
            }
            buf.append(s);
            first = false;
            ++n2;
        }
        buf.append(")");
        return buf.toString();
    }

    public int size() {
        return this.segments.length;
    }

    public YamlPathSegment getSegment(int segment) {
        if (segment >= 0 && segment < this.segments.length) {
            return this.segments[segment];
        }
        return null;
    }

    public YamlPath append(YamlPathSegment s) {
        YamlPathSegment[] newPath = Arrays.copyOf(this.segments, this.segments.length + 1);
        newPath[this.segments.length] = s;
        return new YamlPath(newPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends YamlNavigable<T>> T traverse(T startNode) {
        try {
            Object node = startNode;
            YamlPathSegment[] yamlPathSegmentArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return node;
                }
                YamlPathSegment s = yamlPathSegmentArray[n2];
                if (node == null) {
                    return null;
                }
                node = (YamlNavigable)node.traverse(s);
                ++n2;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public YamlPath dropFirst(int dropCount) {
        if (dropCount >= this.size()) {
            return EMPTY;
        }
        if (dropCount == 0) {
            return this;
        }
        YamlPathSegment[] newPath = new YamlPathSegment[this.segments.length - dropCount];
        int i = 0;
        while (i < newPath.length) {
            newPath[i] = this.segments[i + dropCount];
            ++i;
        }
        return new YamlPath(newPath);
    }

    public YamlPath dropLast() {
        return this.dropLast(1);
    }

    public YamlPath dropLast(int dropCount) {
        if (dropCount >= this.size()) {
            return EMPTY;
        }
        if (dropCount == 0) {
            return this;
        }
        YamlPathSegment[] newPath = new YamlPathSegment[this.segments.length - dropCount];
        int i = 0;
        while (i < newPath.length) {
            newPath[i] = this.segments[i];
            ++i;
        }
        return new YamlPath(newPath);
    }

    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    public YamlPath tail() {
        return this.dropFirst(1);
    }

    public static YamlPath fromASTPath(List<NodeRef<?>> path) {
        ArrayList<YamlPathSegment> segments = new ArrayList<YamlPathSegment>(path.size());
        for (NodeRef<?> nodeRef : path) {
            switch (nodeRef.getKind()) {
                case ROOT: {
                    NodeRef.RootRef rref = (NodeRef.RootRef)nodeRef;
                    segments.add(YamlPathSegment.valueAt(rref.getIndex()));
                    break;
                }
                case KEY: {
                    String key = NodeUtil.asScalar(nodeRef.get());
                    if (key == null) {
                        return null;
                    }
                    segments.add(YamlPathSegment.keyAt(key));
                    break;
                }
                case VAL: {
                    NodeRef.TupleValueRef vref = (NodeRef.TupleValueRef)nodeRef;
                    String key = NodeUtil.asScalar(vref.getTuple().getKeyNode());
                    if (key == null) {
                        return null;
                    }
                    segments.add(YamlPathSegment.valueAt(key));
                    break;
                }
                case SEQ: {
                    NodeRef.SeqRef sref = (NodeRef.SeqRef)nodeRef;
                    segments.add(YamlPathSegment.valueAt(sref.getIndex()));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return new YamlPath(segments);
    }

    public YamlPathSegment getLastSegment() {
        if (!this.isEmpty()) {
            return this.segments[this.segments.length - 1];
        }
        return null;
    }

    public String getBeanPropertyName() {
        YamlPathSegment lastSegment;
        YamlPathSegment.YamlPathSegmentType kind;
        if (!(this.isEmpty() || (kind = (lastSegment = this.getLastSegment()).getType()) != YamlPathSegment.YamlPathSegmentType.KEY_AT_KEY && kind != YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY)) {
            return lastSegment.toPropString();
        }
        return null;
    }

    public boolean pointsAtKey() {
        YamlPathSegment s = this.getLastSegment();
        return s != null && s.getType() == YamlPathSegment.YamlPathSegmentType.KEY_AT_KEY;
    }

    public boolean pointsAtValue() {
        YamlPathSegment s = this.getLastSegment();
        if (s != null) {
            YamlPathSegment.YamlPathSegmentType type = s.getType();
            return type == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY || type == YamlPathSegment.YamlPathSegmentType.VAL_AT_INDEX;
        }
        return false;
    }

    public YamlPath commonPrefix(YamlPath other) {
        ArrayList<YamlPathSegment> common = new ArrayList<YamlPathSegment>(this.size());
        int i = 0;
        while (i < this.size()) {
            YamlPathSegment s = this.getSegment(i);
            if (s.equals(other.getSegment(i))) {
                common.add(s);
            }
            ++i;
        }
        return new YamlPath(common);
    }
}

