/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.reconcile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;
import org.springframework.ide.eclipse.editor.support.yaml.ast.NodeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlASTReconciler;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlSchemaProblems;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YamlSchema;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class SchemaBasedYamlASTReconciler
implements YamlASTReconciler {
    private final IProblemCollector problems;
    private final YamlSchema schema;
    private final YTypeUtil typeUtil;

    public SchemaBasedYamlASTReconciler(IProblemCollector problems, YamlSchema schema) {
        this.problems = problems;
        this.schema = schema;
        this.typeUtil = schema.getTypeUtil();
    }

    @Override
    public void reconcile(YamlFileAST ast, IProgressMonitor mon) {
        List<Node> nodes = ast.getNodes();
        if (nodes != null && !nodes.isEmpty()) {
            mon.beginTask("Reconcile", nodes.size());
            try {
                for (Node node : nodes) {
                    this.reconcile(node, this.schema.getTopLevelType());
                    mon.worked(1);
                }
            }
            finally {
                mon.done();
            }
        }
    }

    private void reconcile(Node node, YType type) {
        if (type != null) {
            switch (node.getNodeId()) {
                case mapping: {
                    MappingNode map = (MappingNode)node;
                    if (this.typeUtil.isMap(type)) {
                        for (NodeTuple entry : map.getValue()) {
                            this.reconcile(entry.getKeyNode(), this.typeUtil.getKeyType(type));
                            this.reconcile(entry.getValueNode(), this.typeUtil.getDomainType(type));
                        }
                        break;
                    }
                    if (this.typeUtil.isBean(type)) {
                        Map<String, YTypedProperty> beanProperties = this.typeUtil.getPropertiesMap(type);
                        for (NodeTuple entry : map.getValue()) {
                            Node keyNode = entry.getKeyNode();
                            String key = NodeUtil.asScalar(keyNode);
                            if (key == null) {
                                this.expectScalar(node);
                                continue;
                            }
                            YTypedProperty prop = beanProperties.get(key);
                            if (prop == null) {
                                this.unknownBeanProperty(keyNode, type, key);
                                continue;
                            }
                            this.reconcile(entry.getValueNode(), prop.getType());
                        }
                        break;
                    }
                    this.expectTypeButFoundMap(type, node);
                    break;
                }
                case sequence: {
                    SequenceNode seq = (SequenceNode)node;
                    if (this.typeUtil.isSequencable(type)) {
                        for (Node el : seq.getValue()) {
                            this.reconcile(el, this.typeUtil.getDomainType(type));
                        }
                        break;
                    }
                    this.expectTypeButFoundSequence(type, node);
                    break;
                }
                case scalar: {
                    if (this.typeUtil.isAtomic(type)) {
                        ValueParser parser = this.typeUtil.getValueParser(type);
                        if (parser == null) break;
                        try {
                            parser.parse(NodeUtil.asScalar(node));
                        }
                        catch (Exception e) {
                            String msg = ExceptionUtil.getMessage((Throwable)e);
                            this.valueParseError(type, node, msg);
                        }
                        break;
                    }
                    this.expectTypeButFoundScalar(type, node);
                }
            }
        }
    }

    private void valueParseError(YType type, Node node, String parseErrorMsg) {
        String msg = "Couldn't parse as '" + this.describe(type) + "'";
        if (StringUtils.hasText((String)parseErrorMsg)) {
            msg = String.valueOf(msg) + " (" + parseErrorMsg + ")";
        }
        this.problem(node, msg);
    }

    private void unknownBeanProperty(Node keyNode, YType type, String name) {
        this.problem(keyNode, "Unknown property '" + name + "' for type '" + this.typeUtil.niceTypeName(type) + "'");
    }

    private void expectScalar(Node node) {
        this.problem(node, "Expecting a 'Scalar' node but got " + this.describe(node));
    }

    private String describe(Node node) {
        switch (node.getNodeId()) {
            case scalar: {
                return "'" + ((ScalarNode)node).getValue() + "'";
            }
            case mapping: {
                return "a 'Mapping' node";
            }
            case sequence: {
                return "a 'Sequence' node";
            }
            case anchor: {
                return "a 'Anchor' node";
            }
        }
        throw new IllegalStateException("Missing switch case");
    }

    private void expectTypeButFoundScalar(YType type, Node node) {
        this.problem(node, "Expecting a '" + this.describe(type) + "' but found a 'Scalar'");
    }

    private void expectTypeButFoundSequence(YType type, Node node) {
        this.problem(node, "Expecting a '" + this.describe(type) + "' but found a 'Sequence'");
    }

    private void expectTypeButFoundMap(YType type, Node node) {
        this.problem(node, "Expecting a '" + this.describe(type) + "' but found a 'Map'");
    }

    private String describe(YType type) {
        if (this.typeUtil.isAtomic(type)) {
            return this.typeUtil.niceTypeName(type);
        }
        ArrayList<String> expectedNodeTypes = new ArrayList<String>();
        if (this.typeUtil.isBean(type) || this.typeUtil.isMap(type)) {
            expectedNodeTypes.add("Map");
        }
        if (this.typeUtil.isSequencable(type)) {
            expectedNodeTypes.add("Sequence");
        }
        return StringUtils.collectionToDelimitedString(expectedNodeTypes, (String)" or ");
    }

    private void problem(Node node, String msg) {
        this.problems.accept(YamlSchemaProblems.schemaProblem(msg, node));
    }
}

