/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.reconcile;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.editor.support.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.editor.support.yaml.reconcile.YamlASTReconciler;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public abstract class YamlReconcileEngine
implements IReconcileEngine {
    protected final YamlASTProvider parser;

    public YamlReconcileEngine(YamlASTProvider parser) {
        this.parser = parser;
    }

    /*
     * Loose catch block
     */
    @Override
    public void reconcile(IDocument doc, IProblemCollector problemCollector, IProgressMonitor mon) {
        block10: {
            problemCollector.beginCollecting();
            try {
                try {
                    YamlFileAST ast = this.parser.getAST(doc);
                    YamlASTReconciler reconciler = this.getASTReconciler(doc, problemCollector);
                    if (reconciler != null) {
                        reconciler.reconcile(ast, mon);
                    }
                }
                catch (ParserException e) {
                    String msg = e.getProblem();
                    Mark mark = e.getProblemMark();
                    problemCollector.accept(this.syntaxError(msg, mark.getIndex(), 1));
                    problemCollector.endCollecting();
                }
                catch (ScannerException e) {
                    String msg = e.getProblem();
                    Mark mark = e.getProblemMark();
                    problemCollector.accept(this.syntaxError(msg, mark.getIndex(), 1));
                    problemCollector.endCollecting();
                }
                catch (Exception e) {
                    EditorSupportActivator.log(e);
                    problemCollector.endCollecting();
                    break block10;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                problemCollector.endCollecting();
            }
        }
    }

    protected abstract ReconcileProblem syntaxError(String var1, int var2, int var3);

    protected abstract YamlASTReconciler getASTReconciler(IDocument var1, IProblemCollector var2);
}

