/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.reconcile;

import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblemImpl;
import org.yaml.snakeyaml.nodes.Node;

public class YamlSchemaProblems {
    private static final ProblemType SCHEMA_PROBLEM = YamlSchemaProblems.problemType("YamlSchemaProblem");
    private static final ProblemType SYNTAX_PROBLEM = YamlSchemaProblems.problemType("YamlSyntaxProblem");

    private static ProblemType problemType(final String typeName) {
        return new ProblemType(){

            @Override
            public String toString() {
                return typeName;
            }

            @Override
            public ProblemSeverity getDefaultSeverity() {
                return ProblemSeverity.ERROR;
            }
        };
    }

    public static ReconcileProblem syntaxProblem(String msg, int offset, int len) {
        return new ReconcileProblemImpl(SYNTAX_PROBLEM, msg, offset, len);
    }

    public static ReconcileProblem schemaProblem(String msg, Node node) {
        int start = node.getStartMark().getIndex();
        int end = node.getEndMark().getIndex();
        return new ReconcileProblemImpl(SCHEMA_PROBLEM, msg, start, end - start);
    }
}

