/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.editor.support.yaml.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.springframework.ide.eclipse.editor.support.hover.DescriptionProviders;
import org.springframework.ide.eclipse.editor.support.util.EnumValueParser;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;
import org.springframework.ide.eclipse.editor.support.yaml.schema.BasicYValueHint;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypeUtil;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YValueHint;

public class YTypeFactory {
    public final YTypeUtil TYPE_UTIL = new YTypeUtil(){

        @Override
        public boolean isSequencable(YType type) {
            return ((AbstractType)type).isSequenceable();
        }

        @Override
        public boolean isMap(YType type) {
            return ((AbstractType)type).isMap();
        }

        @Override
        public boolean isAtomic(YType type) {
            return ((AbstractType)type).isAtomic();
        }

        @Override
        public Map<String, YTypedProperty> getPropertiesMap(YType type) {
            return ((AbstractType)type).getPropertiesMap();
        }

        @Override
        public List<YTypedProperty> getProperties(YType type) {
            return ((AbstractType)type).getProperties();
        }

        @Override
        public YValueHint[] getHintValues(YType type) {
            return ((AbstractType)type).getHintValues();
        }

        @Override
        public YType getDomainType(YType type) {
            return ((AbstractType)type).getDomainType();
        }

        @Override
        public String niceTypeName(YType type) {
            return type.toString();
        }

        @Override
        public YType getKeyType(YType type) {
            return ((AbstractType)type).getKeyType();
        }

        @Override
        public boolean isBean(YType type) {
            return ((AbstractType)type).isBean();
        }

        @Override
        public ValueParser getValueParser(YType type) {
            return ((AbstractType)type).getParser();
        }
    };

    public YType yseq(YType el) {
        return new YSeqType(el);
    }

    public YType ymap(YType key, YType val) {
        return new YMapType(key, val);
    }

    public YBeanType ybean(String name, YTypedProperty ... properties) {
        return new YBeanType(name, properties);
    }

    public YAtomicType yatomic(String name) {
        return new YAtomicType(name);
    }

    public YTypedPropertyImpl yprop(String name, YType type) {
        return new YTypedPropertyImpl(name, type);
    }

    public YAtomicType yenum(String name, String ... values) {
        YAtomicType t = this.yatomic(name);
        t.addHints(values);
        t.parseWith(new EnumValueParser(name, values));
        return t;
    }

    public static abstract class AbstractType
    implements YType {
        private ValueParser parser;
        private List<YTypedProperty> propertyList = new ArrayList<YTypedProperty>();
        private final List<YValueHint> hints = new ArrayList<YValueHint>();
        private Map<String, YTypedProperty> cachedPropertyMap;
        private Provider<Collection<YValueHint>> hintProvider;

        public boolean isSequenceable() {
            return false;
        }

        public boolean isBean() {
            return false;
        }

        public YType getKeyType() {
            return null;
        }

        public YType getDomainType() {
            return null;
        }

        public void addHintProvider(Provider<Collection<YValueHint>> hintProvider) {
            this.hintProvider = hintProvider;
        }

        public YValueHint[] getHintValues() {
            Collection providerHints;
            Collection collection = providerHints = this.hintProvider != null ? (Collection)this.hintProvider.get() : null;
            if (providerHints == null || providerHints.isEmpty()) {
                return this.hints.toArray(new YValueHint[this.hints.size()]);
            }
            LinkedHashSet<YValueHint> mergedHints = new LinkedHashSet<YValueHint>();
            for (YValueHint val : this.hints) {
                mergedHints.add(val);
            }
            for (YValueHint val : providerHints) {
                mergedHints.add(val);
            }
            return mergedHints.toArray(new YValueHint[mergedHints.size()]);
        }

        public final List<YTypedProperty> getProperties() {
            return Collections.unmodifiableList(this.propertyList);
        }

        public final Map<String, YTypedProperty> getPropertiesMap() {
            if (this.cachedPropertyMap == null) {
                this.cachedPropertyMap = new LinkedHashMap<String, YTypedProperty>();
                for (YTypedProperty p : this.propertyList) {
                    this.cachedPropertyMap.put(p.getName(), p);
                }
            }
            return Collections.unmodifiableMap(this.cachedPropertyMap);
        }

        public boolean isAtomic() {
            return false;
        }

        public boolean isMap() {
            return false;
        }

        public abstract String toString();

        public void addProperty(YTypedProperty p) {
            this.cachedPropertyMap = null;
            this.propertyList.add(p);
        }

        public void addProperty(String name, YType type, Provider<HtmlSnippet> description) {
            YTypedPropertyImpl prop = new YTypedPropertyImpl(name, type);
            this.addProperty(prop);
            prop.setDescriptionProvider(description);
        }

        public void addProperty(String name, YType type) {
            this.addProperty(new YTypedPropertyImpl(name, type));
        }

        public void addHints(String ... strings) {
            if (strings != null) {
                String[] stringArray = strings;
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    BasicYValueHint hint = new BasicYValueHint(value);
                    if (!this.hints.contains(hint)) {
                        this.hints.add(hint);
                    }
                    ++n2;
                }
            }
        }

        public void parseWith(ValueParser parser) {
            this.parser = parser;
        }

        public ValueParser getParser() {
            return this.parser;
        }
    }

    public static class YAtomicType
    extends AbstractType {
        private final String name;

        private YAtomicType(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean isAtomic() {
            return true;
        }
    }

    public static class YBeanType
    extends AbstractType {
        private final String name;

        public YBeanType(String name, YTypedProperty[] properties) {
            this.name = name;
            YTypedProperty[] yTypedPropertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                YTypedProperty p = yTypedPropertyArray[n2];
                this.addProperty(p);
                ++n2;
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean isBean() {
            return true;
        }
    }

    public static class YMapType
    extends AbstractType {
        private final YType key;
        private final YType val;

        private YMapType(YType key, YType val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String toString() {
            return "Map<" + this.key.toString() + ",\u00a0" + this.val.toString() + ">";
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public YType getKeyType() {
            return this.key;
        }

        @Override
        public YType getDomainType() {
            return this.val;
        }
    }

    public static class YSeqType
    extends AbstractType {
        private YType el;

        private YSeqType(YType el) {
            this.el = el;
        }

        @Override
        public String toString() {
            return String.valueOf(this.el.toString()) + "[]";
        }

        @Override
        public boolean isSequenceable() {
            return true;
        }

        @Override
        public YType getDomainType() {
            return this.el;
        }
    }

    public static class YTypedPropertyImpl
    implements YTypedProperty {
        private final String name;
        private final YType type;
        private Provider<HtmlSnippet> descriptionProvider = DescriptionProviders.NO_DESCRIPTION;

        private YTypedPropertyImpl(String name, YType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public YType getType() {
            return this.type;
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.type;
        }

        @Override
        public HtmlSnippet getDescription() {
            return (HtmlSnippet)this.descriptionProvider.get();
        }

        public void setDescriptionProvider(Provider<HtmlSnippet> descriptionProvider) {
            this.descriptionProvider = descriptionProvider;
        }
    }
}

