/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.templates;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.springframework.ide.eclipse.boot.util.Log;

public class BootJavaContext
extends JavaContext {
    private static final Pattern CONTEXT_TAG = Pattern.compile("\\[[^\\[\\]]*\\]");
    public static final Map<String, Predicate<BootJavaContext>> CONTEXT_TAG_CHECKERS = BootJavaContext.negate(ImmutableMap.of((Object)"test", BootJavaContext::isTestContext, (Object)"assertj", BootJavaContext::isAssertJContext));

    public BootJavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    private static <T> Map<String, Predicate<T>> negate(ImmutableMap<String, Predicate<T>> base) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(base);
        for (Map.Entry e : base.entrySet()) {
            String name = (String)e.getKey();
            if (name.startsWith("!")) continue;
            builder.put((Object)("!" + name), ((Predicate)e.getValue()).negate());
        }
        return builder.build();
    }

    public BootJavaContext(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    public boolean canEvaluate(Template template) {
        if (super.canEvaluate(template)) {
            List<String> contextTags = this.parseContextTags(template);
            for (String tag : contextTags) {
                Predicate<BootJavaContext> checker = CONTEXT_TAG_CHECKERS.get(tag);
                if (checker == null || checker.test(this)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<String> parseContextTags(Template template) {
        return this.parseContextTags(template.getDescription());
    }

    private List<String> parseContextTags(String text) {
        Matcher matcher = CONTEXT_TAG.matcher(text);
        ArrayList<String> tags = new ArrayList<String>();
        while (matcher.find()) {
            tags.add(text.substring(matcher.start() + 1, matcher.end() - 1));
        }
        return tags;
    }

    public boolean isAssertJContext() {
        try {
            IJavaProject jp;
            ICompilationUnit cu = this.getCompilationUnit();
            if (cu != null && (jp = cu.getJavaProject()) != null) {
                IType t = jp.findType("org.assertj.core.api.Assertions");
                return t != null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTestContext() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            if (cu == null) return false;
            IPackageFragmentRoot pfr = (IPackageFragmentRoot)cu.getAncestor(3);
            if (pfr == null) return false;
            IClasspathEntry cpe = pfr.getRawClasspathEntry();
            if (cpe.getEntryKind() != 3) return false;
            IPath sourcePath = cpe.getPath().removeFirstSegments(1);
            if (sourcePath == null) return false;
            String[] stringArray = sourcePath.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String segment = stringArray[n2];
                if (segment.equals("test")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    public static class ContextVariableResolver
    extends TemplateVariableResolver {
        public void resolve(TemplateVariable variable, TemplateContext context) {
            variable.setValue("");
        }
    }
}

